<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePayrollsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('payrolls', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('payroll_officer');
            $table->integer('type')->comment('1 = weekly, 2 = semi-monthly, 3 = monthly');
            $table->integer('entity_type')->comment('1 = branch, 2 = department, 3 = position, 4 = individual, 5 = all employees');
            $table->integer('entity')->comment('ID of entity')->nullable();
            $table->date('period_start');
            $table->date('period_end');
            $table->text('file')->nullable();
            $table->integer('status')->comment('1 = For Review, 2 = Disbursed, 3 = Void');
            $table->text('remarks')->nullable();
            $table->date('completion_date')->nullable();
            $table->integer('created_by');
            $table->integer('updated_by');

            $table->foreign('payroll_officer')->references('id')->on(env('DB_DATABASE') . '.users');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('payrolls');
    }
}
