<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTrainingBondsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('training_bonds', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('employee_type');
            $table->unsignedBigInteger('department');
            $table->unsignedBigInteger('position');
            $table->date('date_from');
            $table->date('date_to');
            $table->integer('status')->comment('1 = active, 2 = inactive');
            $table->integer('duration');
            $table->integer('wave_option');
            $table->integer('created_by');
            $table->integer('updated_by');

            $table->foreign('employee_type')->references('id')->on(env('ADG_DB_DATABASE').'.employee_types');
            $table->foreign('department')->references('id')->on(env('ADG_DB_DATABASE').'.departments');
            $table->foreign('user_id')->references('id')->on(env('DB_DATABASE').'.users');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('training_bonds');
    }
}
