<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDemeritsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('demerits', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->integer('subject');
            $table->date('effect_date');
            $table->text('message')->nullable();
            $table->decimal('points');
            $table->integer('status')->comment('1 = approved, 2 = declined, 3 = pending');
            $table->integer('created_by');
            $table->integer('updated_by');

            $table->foreign('user_id')->references('id')->on(env('DB_DATABASE').'.users');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('demerits');
    }
}
