<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateSalaryPositionColumn extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->table('employee_meta_info', function ($table) {
            $table->unsignedBigInteger('salary_id')->nullable()->change();
            $table->unsignedBigInteger('position_id')->nullable()->change();
            $table->foreign('employee_type')->references('id')->on('employee_types');
            $table->foreign('salary_id')->references('id')->on('salary_grades');
            $table->foreign('position_id')->references('id')->on(env('HRJP_DB_DATABASE').'.positions');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
