<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAttendancesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('attendances', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->date("date_in");
            $table->string("total");
            $table->time("time_in");
            $table->time("time_out")->nullable();
            $table->string("remarks")->nullable();
            $table->integer("legend")->comment('1 = standard, 2 = overtime, 3 = undertime, 4 = late');
            $table->integer("type")->comment('1 = employee clock-in/clock-out, 2 = manual')->default(1);
            $table->unsignedBigInteger('created_by');
            $table->unsignedBigInteger('updated_by');
            $table->softDeletes();
            $table->timestamps();


            $table->foreign('user_id')->references('id')->on(env('DB_DATABASE').'.users');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('attendances');
    }
}
