<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSalaryGradesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('salary_grades', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('ss_id');
            $table->foreign('ss_id')->references('id')->on(env('ADG_DB_DATABASE') . '.salary_standardizations');
            $table->integer('salary_grade');
            // $table->decimal('step1');
            // $table->decimal('step2');
            // $table->decimal('step3');
            // $table->decimal('step4');
            // $table->decimal('step5');
            // $table->decimal('step6');
            // $table->decimal('step7');
            // $table->decimal('step8');
            $table->integer('step');
            $table->decimal('value');
            $table->integer('status');
            $table->unsignedBigInteger('created_by');
            $table->unsignedBigInteger('updated_by');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('salary_grades');
    }
}
