<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateScheduleTemplatesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('schedule_templates', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('title_id');
            $table->foreign('title_id')->references('id')->on( env('ADG_DB_DATABASE') . '.schedule_titles' );
            $table->string('day')->nullable();
            $table->time('time_start');
            $table->time('time_end')->nullable();
            $table->time('max_time')->nullable();
            $table->integer('minutes')->nullable();
            $table->integer('status');
            $table->integer('created_by');
            $table->integer('updated_by');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('schedule_templates');
    }
}
