<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateScheduleTitlesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('schedule_titles', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('type');
            $table->foreign('type')->references('id')->on( env('ADG_DB_DATABASE') . '.schedule_types' );
            $table->string('title');
            $table->text('description')->nullable();
            $table->integer('hasSchedule')->comment('1 = has schedule, 2 = no schedule');
            $table->integer('basis')->comment('1 = schedule-based, 2 = work hours-based (weekly)');
            $table->integer('status');
            $table->integer('created_by');
            $table->integer('updated_by');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('schedule_titles');
    }
}
