<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEmployeeExtraFieldColumnsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('employee_extra_field_columns', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('eef_id');
            $table->string('field_name', 255);
            $table->string('field_label');
            $table->string('field_value', 255);
            $table->string('field_type', 255);
            $table->integer('field_status');
            $table->unsignedBigInteger('created_by');
            $table->timestamps();
            $table->unsignedBigInteger('modified_by')->nullable();
            $table->softDeletes();
            $table->foreign('eef_id')->references('id')->on('employee_extra_fields');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('employee_extra_field_columns');
    }
}
