<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEmployeeMetaInfosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('employee_meta_info', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id')->unique();
            $table->string('employee_id')->unique();
            $table->unsignedBigInteger('employee_type');
            $table->unsignedBigInteger('corp_id');
            $table->unsignedBigInteger('branch_id');
            $table->unsignedBigInteger('division_id');
            $table->unsignedBigInteger('department_id');
            $table->unsignedBigInteger('salary_id');
            $table->unsignedBigInteger('position_id');
            $table->date('date_hired');
            $table->unsignedBigInteger('created_by');
            $table->timestamps();
            $table->unsignedBigInteger('modified_by')->nullable();
            $table->softDeletes();
            $table->foreign('user_id')->references('id')->on(env('DB_DATABASE') . '.users');
            $table->foreign('corp_id')->references('id')->on('corporations');
            $table->foreign('branch_id')->references('id')->on('branches');
            $table->foreign('division_id')->references('id')->on('divisions');
            $table->foreign('department_id')->references('id')->on('departments');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('employee_meta_infos');
    }
}
