<?php

namespace Suiterus\Adg\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use App\Http\Classes\NotificationMessage;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Suiterus\Adg\Models\LeaveManagement\LeaveType;
use Suiterus\Adg\Models\LeaveManagement\ForcedLeaveCounter;
use Suiterus\Adg\Models\LeaveManagement\LeaveCreditHistory;
use Suiterus\Adg\Models\LeaveManagement\Crediting\LeaveBalance;
use Suiterus\Adg\Services\EmailNotification\EmailNotificationService;

class DeductFLtoVLJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public $leaveBalance;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(LeaveBalance $leaveBalance)
    {
        $this->leaveBalance = $leaveBalance;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        DB::connection(env('ADG_DB_CONNECTION'))->transaction(function () {
            $active = 1;
            $initialPoints = LeaveType::where('title', 'Mandatory/Forced Leave')->first()->initial_points;
            $deducted = 2;

            $forcedLeaveCounter = ForcedLeaveCounter::where('user_id', $this->leaveBalance->user_id)->whereHas('user', function ($query) use ($active) {
                $query->where('status', $active);
            })->first();

            if ($forcedLeaveCounter) {
                if ($forcedLeaveCounter->counter <= 0) {
                    $forcedLeaveCounter->update([
                        'counter' => $initialPoints
                    ]);
                    return;
                }
                $remainingBalance = $this->leaveBalance->balance - $forcedLeaveCounter->counter;
                $this->leaveBalance->update([
                    'balance' => $remainingBalance <= 0 ? 0 : $remainingBalance
                ]);

                LeaveCreditHistory::create([
                    'user_id' => $this->leaveBalance->user_id,
                    'leave_type_id' => $this->leaveBalance->leave_type_id,
                    'credits' => $forcedLeaveCounter->counter,
                    'resulting_balance' => $remainingBalance <= 0 ? 0 : $remainingBalance,
                    'leave_adjustment_type' => $deducted,
                    'remarks' => 'Vacation Leave Deduction from Mandatory/Forced Leave',
                    'period' => Carbon::now(),
                    'created_by' => 2,
                ]);

                $forcedLeaveCounter->update([
                    'counter' => $initialPoints
                ]);

                $system = 1;
                NotificationMessage::notifyReceiver('Vacation Leave Deduction from Mandatory/Forced Leave', $this->leaveBalance->user_id, $system);
                (new EmailNotificationService)->sendMailNotification($this->leaveBalance->user->email, 'Vacation Leave Deduction from Mandatory/Forced Leave', 'Your vacation leave balance has been adjusted due to the remaining forced leave. Please review your updated leave status', $this->leaveBalance->user->name);
            }
        });
    }
}
