<?php

namespace Suiterus\Adg\Imports;

use Carbon\Carbon;
use App\Models\User;
use App\Helper\InitialsExtractor;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use Suiterus\Adg\Models\SM\Branch;
use Suiterus\Hrjp\Models\Position;
use Illuminate\Support\Facades\Auth;
use Suiterus\Adg\Models\SM\Division;
use Suiterus\Adg\Models\SM\Department;
use Suiterus\Adg\Models\SM\Corporation;
use Suiterus\Adg\Models\SM\EmployeeType;
use Suiterus\Adg\Models\SM\ScheduleTitle;
use Maatwebsite\Excel\Concerns\Importable;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithStartRow;

use MikeMcLin\WpPassword\Facades\WpPassword;
use Suiterus\Adg\Models\SM\BulkProfileRules;
use Maatwebsite\Excel\Concerns\SkipsFailures;
use Suiterus\Adg\Models\EMI\EmployeeMetaInfo;
use Maatwebsite\Excel\Concerns\SkipsOnFailure;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithValidation;
use Suiterus\Adg\Models\EMI\EmployeeExtraField;
use Maatwebsite\Excel\Concerns\WithMultipleSheets;
use App\Services\AccountSyncing\WpAccountSyncService;
use Suiterus\Adg\Models\EMI\EmployeeExtraFieldColumn;
use Suiterus\Adg\Models\Timekeeping\EmployeeSchedule;

use Suiterus\Adg\Controllers\Services\LeaveCreditService;

use Suiterus\Adg\Controllers\Approvals\Services\COCPointService;
use Suiterus\Hrjp\Models\ItemCode;

class EmployeeImport implements ToCollection, WithStartRow, SkipsOnFailure, WithHeadingRow, WithValidation, WithMultipleSheets
{

    private $rows = 0;

    use Importable, SkipsFailures;

    public function sheets(): array
    {
        return [
            0 => $this
        ];
    }


    /**
    * @param Collection $collection
    */
    public function collection(Collection $rows){
        foreach ($rows->chunk(300) as $chunk) {
            foreach($chunk as $row){
                if (count($row) == 29) {
                    

                    $column_names = array_keys(json_decode(json_encode($row), true));
                    foreach ($column_names as $column_name) {
                        $row[$column_name] = (ctype_space($row[$column_name]) || str_contains(strtolower($row[$column_name]), "select") || $row[$column_name] == null) ? 'N/A' : $row[$column_name];
                    }

                    $employeeType = EmployeeType::select('id')->where('title', $row['employee_type'])->get();
                    $position = Position::select('id')->where('title', $row['position'])->get();
                    $itemCode = ItemCode::select('id')->where('item_code', $row['item_code'])->first();
                    $corporation = Corporation::select('id')->where('name', $row['corporation'])->first();
                    $branch = Branch::select('id')->where('name', $row['branch'])->first();
                    $division = Division::select('id')->where('name', $row['division'])->first();
                    $department = Department::select('id')->where('name', $row['department'])->first();

                    $tableName = array();

                    DB::connection(env('DB_CONNECTION'))->beginTransaction();


                    $isEmailExist = User::where('email', $row['e_mail'])->get();

                    $row['e_mail'] = ($isEmailExist->count() > 0 || $row['e_mail'] === '' || strtoupper($row['e_mail']) === 'N/A' || $row['e_mail'] === null || !filter_var($row['e_mail'], FILTER_VALIDATE_EMAIL)) ? $this->generateEmail($row) : $row['e_mail'];

                    $tableName['personal_information'] = array([
                        [
                            'field_name' => 'employee_no',
                            'field_value' => $row['employee_no'],
                            'field_type' => 'text',
                            'field_label' => 'Agency Employee No.',
                            'field_status' => 1,
                        ],
                        [
                            'field_name' => 'last_name',
                            'field_value' => $row['last_name'],
                            'field_type' => 'text',
                            'field_label' => 'Last Name',
                            'field_status' => 1,
                        ],
                        [
                            'field_name' => 'email',
                            'field_value' => $row['e_mail'],
                            'field_type' => 'text',
                            'field_label' => 'Email Address',
                            'field_status' => 1,
                        ],
                        [
                            'field_name' => 'first_name',
                            'field_value' => $row['first_name'],
                            'field_type' => 'text',
                            'field_label' => 'First Name',
                            'field_status' => 1,
                        ],
                        [
                            'field_name' => 'gsis_id',
                            'field_value' => $row['gsis_id'] ?? 'N/A',
                            'field_type' => 'text',
                            'field_label' => 'GSID ID No.',
                            'field_status' => 1,
                        ],
                        [
                            'field_name' => 'middle_name',
                            'field_value' => $row['middle_name'],
                            'field_type' => 'text',
                            'field_label' => 'Middle Name',
                            'field_status' => 1,
                        ],
                        [
                            'field_name' => 'pagibig_no',
                            'field_value' => $row['pagibig_no'] ?? 'N/A',
                            'field_type' => 'text',
                            'field_label' => 'PAGIBIG ID No.',
                            'field_status' => 1,
                        ],
                        [
                            'field_name' => 'name_extension',
                            'field_value' => $row['suffix'],
                            'field_type' => 'text',
                            'field_label' => 'Name Extension (Jr., Sr)',
                            'field_status' => 1,
                        ],
                        [
                            'field_name' => 'philhealth_id',
                            'field_value' => $row['philhealth_id'] ?? 'N/A',
                            'field_type' => 'text',
                            'field_label' => 'PHILHEALTH ID No.',
                            'field_status' => 1,
                        ],
                        [
                            'field_name' => 'date_of_birth',
                            'field_value' => $row['date_of_birth_mmddyyyy'],
                            'field_type' => 'date',
                            'field_label' => 'Date of Birth',
                            'field_status' => 1,
                        ],
                        [
                            'field_name' => 'sss_id',
                            'field_value' => $row['sss_id'] ?? 'N/A',
                            'field_type' => 'date',
                            'field_label' => 'SSS ID No.',
                            'field_status' => 1,
                        ],
                        [
                            'field_name' => 'place_of_birth',
                            'field_value' => $row['place_of_birth'],
                            'field_type' => 'text',
                            'field_label' => 'Place of Birth',
                            'field_status' => 1,
                        ],
                        [
                            'field_name' => 'tin_id',
                            'field_value' => $row['tin_id'] ?? 'N/A',
                            'field_type' => 'text',
                            'field_label' => 'TIN ID No.',
                            'field_status' => 1,
                        ]
                    ]);

                    $tableName['residential_address'] = array([
                        [
                            'field_name' => 'house_block_lot_no',
                            'field_value' => $row['houseblocklot_no'],
                            'field_type' => 'text',
                            'field_label' => 'House/Block/Lot No',
                            'field_status' => 1,
                        ],
                        [
                            'field_name' => 'street',
                            'field_value' => $row['street'],
                            'field_type' => 'text',
                            'field_label' => 'Street',
                            'field_status' => 1,
                        ],
                        [
                            'field_name' => 'subdivision_village',
                            'field_value' => $row['subdivisionvillage'],
                            'field_type' => 'text',
                            'field_label' => 'Subdivision/Village',
                            'field_status' => 1,
                        ],
                        [
                            'field_name' => 'barangay',
                            'field_value' => $row['barangay'],
                            'field_type' => 'text',
                            'field_label' => 'Barangay',
                            'field_status' => 1,
                        ],
                        [
                            'field_name' => 'city_municipality',
                            'field_value' => $row['citymunicipality'],
                            'field_type' => 'text',
                            'field_label' => 'City/Municipality',
                            'field_status' => 1,
                        ],
                        [
                            'field_name' => 'province',
                            'field_value' => $row['province'],
                            'field_type' => 'text',
                            'field_label' => 'Province',
                            'field_status' => 1,
                        ],
                        [
                            'field_name' => 'zip_code',
                            'field_value' => $row['zip_code'],
                            'field_type' => 'text',
                            'field_label' => 'Zip Code',
                            'field_status' => 1,
                        ]
                    ]);

                    $tableName['pds_choices'] = array([
                        [
                            'field_name' => 'sex',
                            'field_value' => $row['gender'],
                            'field_type' => 'radio',
                            'field_label' => 'No label',
                            'field_status' => 1,
                        ],
                        [
                            'field_name' => 'sex_details',
                            'field_value' => $row['sex_details'] ?? 'N/A',
                            'field_type' => 'text',
                            'field_label' => 'Please specify',
                            'field_status' => 1,
                        ],
                        [
                            'field_name' => 'citizenship',
                            'field_value' => $row['citizenship'],
                            'field_type' => 'radio',
                            'field_label' => 'No label',
                            'field_status' => 1,
                        ],
                        [
                            'field_name' => 'citizenship_details',
                            'field_value' => $row['citizenship_if_holder_of_dual_citizenship_please_indicate_the_details'] ?? 'N/A',
                            'field_type' => 'text',
                            'field_label' => 'Please specify',
                            'field_status' => 1,
                        ],
                        [
                            'field_name' => 'civil_status',
                            'field_value' => $row['civil_status'],
                            'field_type' => 'radio',
                            'field_label' => 'No label',
                            'field_status' => 1,
                        ],
                        [
                            'field_name' => 'civil_status_details',
                            'field_value' => $row['civil_status_if_others_please_specify'] ?? 'N/A',
                            'field_type' => 'text',
                            'field_label' => 'Please specify',
                            'field_status' => 1,
                        ]
                    ]);

                    try {
                
                        $day = Carbon::parse($row['date_of_birth_mmddyyyy'])->format('d');
                        $month = Carbon::parse($row['date_of_birth_mmddyyyy'])->format('m');
                        $password = $day . InitialsExtractor::getInitials($row['first_name']) . $month;

                        $user = User::create([
                            'name'  =>  $row['first_name'] . ' ' . $row['last_name'],
                            'email' =>  $row['e_mail'],
                            'password' => bcrypt($password),
                            'email_verified_at' => now()
                        ]);
                        $lowerFirstName = strtolower($row['first_name']);

                        WpAccountSyncService::syncAccountsToWordpress([
                            'user_login' => preg_replace('/\s+/', '.', $lowerFirstName),
                            'user_pass' => WpPassword::make($password),
                            'user_nicename' => preg_replace('/\s+/', '.', $lowerFirstName),
                            'user_email' => $row['e_mail'],
                            'user_url' => '',
                            'user_registered' => Carbon::now(),
                            'user_activation_key' => '',
                            'user_status' => 0,
                            'display_name' => $row['first_name'] . ' ' . $row['last_name'],
                        ]);

                        //give role
                        $user->assignRole('Employee');
                        //give permissions
                        $user->syncPermissions(1);

                        DB::connection(env('DB_CONNECTION'))->commit();

                        DB::connection(env('ADG_DB_CONNECTION'))->beginTransaction();
                        //uncomment this code if you want to assign default schedule upon importing the employees
                        // $active_schedule = ScheduleTitle::where('active_schedule', 1)->first();

                        // EmployeeSchedule::create([
                        //     'user_id'               => $user->id,
                        //     'schedule_template_id'  => $active_schedule->id,
                        //     'created_by'            => Auth::id()
                        // ]);

                         EmployeeMetaInfo::create([
                            'user_id' => $user->id,
                            'employee_id' => $row['employee_no'],
                            'employee_type' => !$employeeType->isEmpty() ? $employeeType[0]['id'] : null,
                            'corp_id' => $corporation ? $corporation['id'] : null,
                            'branch_id' => $branch ? $branch['id'] : null,
                            'division_id' => $division ? $division['id'] : null,
                            'department_id' => $department ? $department['id'] : null,
                            'salary_id' => null,
                            'item_code_id' =>  $itemCode ? $itemCode['id'] : null,
                            'date_hired'    => date('Y-m-d'),
                            'position_id' => !$position->isEmpty() ? $position[0]['id'] : null,
                            'created_by' => Auth::id()
                        ]);

                        // ETH::create([
                        //     'user_id'               => $user->id,
                        //     'employee_type_id'      => !$employeeType->isEmpty() ? $employeeType[0]['id'] : null,
                        //     'date_of_effectivity'   => now(),
                        //     'status'                => 1,
                        //     'created_by'            => Auth::id(),
                        //     'updated_by'            => Auth::id()
                        //     ]);


                        DB::connection(env('ADG_DB_CONNECTION'))->commit();

                        foreach ($tableName as $table_name => $tableValues) {

                            $employeeExtraField = EmployeeExtraField::create([
                                'user_id' => $user->id,
                                'table_name' => $table_name,
                                'created_by' => Auth::id(),
                            ]);
                            DB::commit();

                            foreach ($tableValues as $tableValue) {
                                foreach ($tableValue as $key => $value) {
                                    EmployeeExtraFieldColumn::create([
                                        'eef_id' => $employeeExtraField->id,
                                        'field_name' => $value['field_name'],
                                        'field_value' => $value['field_value'],
                                        'field_type' => $value['field_type'],
                                        'field_label' => $value['field_label'],
                                        'field_status' => $value['field_status'],
                                        'created_by' => Auth::id()
                                    ]);
                                }
                            }

                        }

                        $leave_service = new LeaveCreditService;
                        $leave_service->initializeEmployeeBalance($user);

                        $coc_service = new COCPointService;
                        $coc_service->initializeCOCPoints($user);

                        $this->rows++;
                    }catch(\Throwable $e){
                        DB::rollBack();
                    }
                }
            }
        }
    }

    /**
     * @return int
     */
    public function startRow(): int
    {
        return 3;
    }

    public function headingRow(): int
    {
        return 2;
    }

    public function rules(): array
    {

        $rules = array();

        $bulkProfile = BulkProfileRules::all();

        foreach ($bulkProfile as $key => $value) {
            $column_name = strtolower(str_replace([' ', '/', '(', ')', '.', '-'], ['_', '', '', '', '' ,'_'], $value['name']));

            if ($column_name == 'employee_type' && $value['is_required'] == 1) {
                $rules['employee_type'] = 'exists:adg_db.employee_types,title|required';
            }else if($column_name == 'position' && $value['is_required'] == 1){
                $rules['position'] = 'exists:hrjp_db.positions,title|required';
            }else if($column_name == 'item_code' && $value['is_required'] == 1){
                $rules['item_code'] = 'exists:hrjp_db.item_codes,item_code|required';
            }else if($column_name == 'employee_no' && $value['is_required'] == 1){
                $rules['employee_no'] = 'unique:adg_db.employee_meta_info,employee_id,user_id|distinct|required';
            }else if($column_name == 'e_mail' && $value['is_required'] == 1){
                $rules['e_mail'] = 'unique:adg_db.employee_extra_field_columns,field_value|distinct|email:rfc,dns|required';
            }else if($column_name == 'date_of_birth' && $value['is_required'] == 1){
                $rules['date_of_birth'] = 'unique:adg_db.employee_extra_field_columns,field_value|distinct|date_of_birth:required';
            }else if($value['is_required'] == 1) {
                $rules[$column_name] = ['required','not_in:N/A,n/a,na,NA','not_regex:/(Select)|(select)/'];
            }

        }

        $rules['date_of_birth'] = 'date';

        return $rules;
    }

    public function customValidationAttributes()
    {
        $bulkProfile = BulkProfileRules::all();
        $names = array();
        $index = 0;
        foreach ($bulkProfile as $key => $value) {
            $names[$index] = $value->name;
            $index++;
        }
        return $names;
    }

    public function getRowCount(): int
    {
        return $this->rows;
    }

    public function generateEmail($row){

        $i = 0;
        while (true) {
            if ($i == 0) {
                $email = strtolower(str_replace(' ', '.', $row['first_name']) . '.' . strtolower(str_replace([' ', '.'], '', $row['last_name'])) . '@nkti.gov.ph');
            }else if($i > 0) {
                $date = date_create();
                $email = strtolower(str_replace(' ', '.', $row['first_name']) . '.' . strtolower(str_replace([' ', '.'], '', $row['last_name'])) . now()->timestamp .'@nkti.gov.ph');
            }

            $user = User::where('email', $email)->get();

            if ($user->count() == 0) {
                return $email;
            }

            $i++;

        }


    }

}
