<?php

namespace Suiterus\Adg\Factories;

use App\Enums\ReportType;
use Suiterus\Adg\Reports\GsisReport;
use Suiterus\Adg\Reports\SalnReport;

use Suiterus\Adg\Reports\PagibigReport;

use Suiterus\Adg\Reports\DailyRateReport;
use Suiterus\Adg\Reports\PhilhealthReport;
use Suiterus\Adg\Reports\PagibigLoanReport;
use Suiterus\Adg\Reports\HiredEmployeeReport;
use Suiterus\Adg\Reports\SpecialPayrollReport;
use Suiterus\Adg\Reports\WithholdingTaxReport;
use Suiterus\Adg\Reports\OtherIncomeDeductionReport;
use Suiterus\Adg\Reports\ResignedEmployeeReport;
use Suiterus\Adg\Reports\RATAReport;
use Suiterus\Adg\Reports\ThirteenthMonthPayReport;

class ReportFactory
{

    /**
     * The function creates different instances of report classes based on the report type.
     * @param int reportType The reportType parameter is an integer that determines the type of report
     * to be created.
     */
    public static function create(int $reportType)
    {
        // insert your code here to create different instance of our report classes
        switch ($reportType) {
            case ReportType::GSIS:
                return new GsisReport();
            case ReportType::PAGIBIG:
                return new PagibigReport();
            case ReportType::PAGIBIG_LOAN:
                return new PagibigLoanReport();
            case ReportType::PHILHEALTH:
                return new PhilhealthReport();
            case ReportType::WITHOLDING_TAX:
                return new WithholdingTaxReport();
            case ReportType::SALN:
                return new SalnReport();
            case ReportType::DAILY_RATE:
                return new DailyRateReport();
            case ReportType::HIRED_EMPLOYEE:
                return new HiredEmployeeReport();
            case ReportType::RESIGNED_EMPLOYEE:
                return new ResignedEmployeeReport();
            case ReportType::RATA:
                return new RATAReport();
            case ReportType::THIRTEENTH_MONTH:
                return new ThirteenthMonthPayReport();
            case ReportType::OTHER_INCOME_DEDUCTIONS:
                return new OtherIncomeDeductionReport();
            case ReportType::SPECIAL_PAYROLL:
                return new SpecialPayrollReport();
            default:
                return;
        }
    }
}
