<?php

namespace Suiterus\Adg\Factories\Contribution;

use App\Enums\ContributoryTypes;
use Exception;
use Suiterus\Adg\Services\Contribution\GsisContributionCalculatorService;
use Suiterus\Adg\Services\Contribution\PagibigContributionCalculatorService;
use Suiterus\Adg\Services\Contribution\PhilHealthContributionCalculatorService;

class ContributionCalculatorFactory
{

    /**
     * The function creates an instance of a contribution calculator service based on the given
     * contributory type.
     * @param String contributoryTypes The parameter  is a string that represents the
     * type of contributory calculator service to create. It can have one of the following values:
     * 'philhealth', 'gsis', or 'pagibig'.
     * @return ContributionCalculator create() function returns an instance of a
     * contribution calculator service based on
     * the provided  parameter.
     */
    public static function create(String $contributoryTypes)
    {
        switch ($contributoryTypes) {
            case ContributoryTypes::PHILHEALTH:
                return new PhilHealthContributionCalculatorService();
            case ContributoryTypes::GSIS:
                return new GsisContributionCalculatorService();
            case ContributoryTypes::PAGIBIG:
                return new PagibigContributionCalculatorService();
            default:
                return;
        }
    }
}
