<?php

namespace Suiterus\Adg\Exports\SpecialPay;

use Carbon\Carbon;
use App\Enums\Status;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Events\AfterSheet;
use PhpOffice\PhpSpreadsheet\NamedRange;
use Illuminate\Support\Facades\Validator;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Style\Border;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithHeadings;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use Maatwebsite\Excel\Concerns\FromCollection;
use PhpOffice\PhpSpreadsheet\Cell\DataValidation;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use Suiterus\Adg\Models\Payroll\SpecialPayFrequency;

class SpecialPayExport implements FromCollection, WithHeadings, WithEvents, WithStyles
{
    private $records;
    private $select;


    public function __construct($rows)
    {
        $this->records = $rows;

        $specialPayFrequency = SpecialPayFrequency::where('status', Status::ACTIVE)
            ->pluck('title')
            ->toArray();


        $frequency = [ 
            ['columns_name' => 'C', 'options' => $specialPayFrequency],
        ];
        $this->select = $frequency;

    }

    public function collection()
    {
        return collect([]);
    }

    public function headings(): array
    {
        return [
            'Title',
            'Description',
            'Special Pay Frequency',
            'Start Date',
            'End Date',
            'Amount',
            'Period',
            'Amount Per Frequency',
        ];
    }

    public function styles(Worksheet $sheet){
            $sheet->getStyle("A1:H1")->getFont()->setBold(true);
            $sheet->getStyle("A2:H2")->getFont()->setBold(true);

            $style = array(
                'alignment' => array(
                    'horizontal' => Alignment::HORIZONTAL_CENTER
                )
            );
        
            $sheet->getStyle("A1:H1")->applyFromArray($style);

            // Column Width
            $sheet->getColumnDimension("A")->setWidth(30.14);
            $sheet->getColumnDimension("B")->setWidth(50.14);
            $sheet->getColumnDimension("C")->setWidth(22.43);
            $sheet->getColumnDimension("D")->setWidth(22.43);
            $sheet->getColumnDimension("E")->setWidth(22.43);
            $sheet->getColumnDimension("F")->setWidth(30.14);
            $sheet->getColumnDimension("G")->setWidth(22.43);
            $sheet->getColumnDimension("H")->setWidth(30.14);
            $sheet->getRowDimension(1)->setRowHeight("30");

            // styling header
            $styleArray = array(
                'borders' => array(
                    'allBorders' => array(
                        'borderStyle' => Border::BORDER_THIN,
                        'color' => array('argb' => '00000000'),
                    ),
                ),
                'alignment' => [
                    'vertical' => Alignment::VERTICAL_CENTER,
                    'horizontal' => Alignment::HORIZONTAL_CENTER,
                    'wrapText' => true
                ],
                ''
            );

            for ($i = 1; $i < $this->records + 3; $i++) { 
                $sheet->getStyle("A" . $i . ":H" . $i)->applyFromArray($styleArray);
            }

            $sheet->getStyle('D')->getNumberFormat()->setFormatCode('yyyy-mm-dd');
            $sheet->getStyle('E')->getNumberFormat()->setFormatCode('yyyy-mm-dd');
            $sheet->getStyle('F')->getNumberFormat()->setFormatCode('#,##0.00');
            $sheet->getStyle('H')->getNumberFormat()->setFormatCode('#,##0.00');

            $sheet->mergeCells('A1:A2');
            $sheet->mergeCells('B1:B2');
            $sheet->mergeCells('C1:C2');
            $sheet->mergeCells('D1:E1');
            $sheet->mergeCells('F1:F2');
            $sheet->mergeCells('G1:G2');
            $sheet->mergeCells('H1:H2');

            $sheet->setCellValue("D1", "Coverage");
            $sheet->setCellValue("D2", "Start Date");
            $sheet->setCellValue("E2", "End Date");
            $sheet->setCellValue("A2", "Title");
            $sheet->setCellValue("B2", "Description");
            $sheet->setCellValue("C2", "Special Pay Frequency");
            $sheet->setCellValue("F2", "Amount");
            $sheet->setCellValue("G2", "Period");
            $sheet->setCellValue("H2", "Amount per Frequency");
    }

    /**
     * Apply data validation for the special pay frequency column.
     */
    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function(AfterSheet $event) {
                foreach ($this->select as $select) {
                    $drop_column = $select['columns_name'];
                    $options = $select['options'];
  
                    for ($i = 3; $i <= $this->records + 2; $i++) {
                        $validation = $event->sheet->getCell("{$drop_column}{$i}")->getDataValidation();
                        $validation->setType(DataValidation::TYPE_LIST);
                        $validation->setErrorStyle(DataValidation::STYLE_INFORMATION);
                        $validation->setAllowBlank(false);
                        $validation->setShowInputMessage(true);
                        $validation->setShowErrorMessage(true);
                        $validation->setShowDropDown(true);
                        $validation->setErrorTitle('Input error');
                        $validation->setError('Value is not in list.');
                        $validation->setPromptTitle('Pick from list');
                        $validation->setPrompt('Please pick a value from the drop-down list.');
                        $validation->setFormula1(sprintf('"%s"', implode(',', $options)));
                    }
                }

                $sheet = $event->sheet->getDelegate();
                for ($i = 3; $i <= $this->records + 2; $i++) {
                    $sheet->setCellValue("G{$i}", "=IF(C{$i}=\"Semi-monthly\", DATEDIF(D{$i}, E{$i}, \"M\") * 2, IF(C{$i}=\"Quarterly\", DATEDIF(D{$i}, E{$i}, \"M\") / 3, IF(C{$i}=\"Annually\", DATEDIF(D{$i}, E{$i}, \"M\") / 12, IF(C{$i}=\"Semi-Annually\", DATEDIF(D{$i}, E{$i}, \"M\") / 6, DATEDIF(D{$i}, E{$i}, \"M\")))))");
                    $sheet->setCellValue("H{$i}", "=IF(G{$i}=0, 0, F{$i}/G{$i})");
                }
            },
        ];
    }
}
