<?php

namespace Suiterus\Adg\Exports\Report;

use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Concerns\WithTitle;
use PhpOffice\PhpSpreadsheet\Style\Color;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Style\Border;
use Illuminate\Database\Eloquent\Collection;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use Maatwebsite\Excel\Concerns\FromCollection;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class SpecialPayrollSheet implements FromCollection, WithTitle, WithStyles, WithEvents
{

    private $title;
    private $records;
    private $headers;

    public function __construct($title, $rows, $headers)
    {
        $this->title = $title;
        $this->records = $rows;
        $this->headers = $headers;
    }

    /**
     * @return Builder
     */
    public function collection()
    {
        return new Collection();
    }

    /**
     * @return string
     */
    public function title(): string
    {
        return $this->title;
    }

    public  function numberToExcelLetter($num)
    {
        $alphabet = $num % 26;
        $letter = chr(65 + $alphabet);
        $store = intval($num / 26);
        if ($store > 0) {
            return $this->numberToExcelLetter($store - 1) . $letter;
        } else {
            return $letter;
        }
    }

    public function styles(Worksheet $sheet)
    {

        $style = array(
            'alignment' => array(
                'horizontal' => Alignment::HORIZONTAL_CENTER
            )
        );



        $index = 0;

        foreach ($this->headers as $header) {
            $sheet->setCellValue($this->numberToExcelLetter($index) . "1", $header);
            $sheet->getStyle($this->numberToExcelLetter($index) . "1")->getFont()->setBold($style);
            $sheet->getColumnDimension($this->numberToExcelLetter($index))->setAutoSize(true);
            $sheet->getStyle($this->numberToExcelLetter($index) . "1")->getBorders()->getOutline()
                ->setBorderStyle(Border::BORDER_THIN)
                ->setColor(new Color('000000'));
            $index++;
        }
    }

    public function registerEvents(): array
    {

        return [
            AfterSheet::class => function (AfterSheet $event) {

                /** @var Sheet $sheet */
                $sheet = $event->sheet;
                $index = 2;

                foreach ($this->records->chunk(300) as $chunks) {
                    foreach ($chunks as $chunk) {
                        $headerIndex = 0;
                        foreach ($this->headers as $header) {
                            if (array_key_exists($header, $chunk)) {
                                $sheet->setCellValue($this->numberToExcelLetter($headerIndex) . $index, $chunk[$header]);
                            } else {
                                $sheet->setCellValue($this->numberToExcelLetter($headerIndex) . $index, 'N/A');
                            }

                            $headerIndex++;
                        }


                        $index++;
                    }
                }
            }
        ];
    }
}
