<?php

namespace Suiterus\Adg\Exports\Payroll;

use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithColumnWidths;
use Maatwebsite\Excel\Concerns\WithDefaultStyles;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithStartRow;
use Maatwebsite\Excel\Concerns\WithStyles;
use Maatwebsite\Excel\Events\AfterSheet;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use Suiterus\Adg\Traits\EmployeeTrait;
use Suiterus\Adg\Traits\EmployerTrait;



class PayrollJournalExport  implements FromArray, WithHeadings, ShouldAutoSize, WithStyles, WithEvents
{
    use Exportable;

    protected $data;
    public function __construct($data)
    {
       $this->data = $data;
    }

    public function array(): array
    {
        return array_slice($this->data, 0, -1);
    }

    public function headings(): array
    {
        $headings = array_keys($this->data[0]);

        return $headings;
    }

    public function styles(Worksheet $sheet)
    {   
        $styleArray = array(
            'alignment' => [
                'horizontal' => Alignment::HORIZONTAL_LEFT,
                'wrapText' => true
            ],
        );

        $headerStyle = [
            'alignment' => [
                'vertical' => Alignment::VERTICAL_CENTER,
                'horizontal' => Alignment::HORIZONTAL_CENTER,
                'wrapText' => true
            ],
            'font' => [
                'bold' => true,
            ],
            'borders' => [
                'allBorders' => [
                    'borderStyle' => Border::BORDER_THIN,
                    'color' => array('argb' => '00000000'),
                ],
            ],
        ];

        $numberStyle = array(
            'alignment' => [
                'vertical' => Alignment::VERTICAL_CENTER,
                'horizontal' => Alignment::HORIZONTAL_RIGHT,
                'wrapText' => true
            ],
        );

        $columns = array_keys($this->data[0]);

        //headers
        $sheet->getStyle([1,1, count($columns), 1])->applyFromArray($headerStyle);
        $sheet->getStyle('B')->applyFromArray($styleArray);

        //data
        $sheet->getStyle([3, 2, count($columns), count($this->data) + 3])->applyFromArray($numberStyle);
        $sheet->getStyle([4, 2, count($columns), count($this->data) + 3])->getNumberFormat()->setFormatCode('0.00');

        //total Styles
        $sheet->getStyle([2, count($this->data) + 3, count($columns), count($this->data) + 3])->getFont()->setBold(true);
        $sheet->getStyle([2, count($this->data) + 3, count($columns), count($this->data) + 3])->getBorders()->getTop()->setBorderStyle(Border::BORDER_THIN);
       
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function (AfterSheet $event) {
                $columns = array_keys($this->data[0]);
                for ($colIndex = 4; $colIndex <= count($columns); $colIndex++) {
                    $result = [];
                    for ($row = 2; $row <= count($this->data) + 1; $row++) {
                        $string = str_replace(',', '', $event->sheet->getCellByColumnAndRow($colIndex, $row)->getValue());
                        $numbers = array_map('floatval', explode("\n", $string));
                        $result = array_map(function ($n1, $n2) {
                            return $n1 + $n2;
                        }, $result, $numbers);
                    }
                    $event->sheet->setCellValueByColumnAndRow(2, count($this->data) + 3, "TOTAL");
                    $formattedResult = array_map(function ($value) {
                        return number_format($value, 2);
                    }, $result);
                    $formattedResult = implode("\n", $formattedResult);
                    $event->sheet->setCellValueByColumnAndRow($colIndex, $row + 1, $formattedResult);
                }

                $titleStyle = array(
                    'alignment' => [
                        'horizontal' => Alignment::HORIZONTAL_CENTER,
                        'vertical' => Alignment::VERTICAL_CENTER,
                        'wrapText' => true
                    ],
                );
                $event->sheet->insertNewRowBefore(1,7);
                $event->sheet->setCellValue('F2',end($this->data)['employer_name']);
                $event->sheet->setCellValue('F3','EAST AVENUE QUEZON CITY');

                $event->sheet->setCellValue('F5','PAYROLL JOURNAL');
                $event->sheet->setCellValue('F6', end($this->data)['date']);
                $event->sheet->getStyle('F2')->getFont()->setSize(15.0);
                $event->sheet->getStyle('F5')->getFont()->setSize(14.0);

                $event->sheet->getStyle([6, 2, 9, 6])->applyFromArray($titleStyle);
                $event->sheet->mergeCells('F2:I2');
                $event->sheet->mergeCells('F3:I3');
                $event->sheet->mergeCells('F5:I5');
                $event->sheet->mergeCells('F6:I6');

            }
        ];
    }
}
   
