<?php

namespace Suiterus\Adg\Exports\PDS;

use Illuminate\Contracts\View\View;
use Illuminate\Support\Facades\App;
use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use App\Exports\PDSExport;
use PDF;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Facades\Excel;
use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithCustomStartCell;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithStartRow;
use Maatwebsite\Excel\Events\BeforeExport;
use Maatwebsite\Excel\Events\BeforeSheet;
use Maatwebsite\Excel\Events\BeforeWriting;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;



class PDSExportsAdmin implements WithEvents
{
    use Exportable;


    public $pds;

    public function __construct($pds) {
        $this->pds = $pds;

    }

    public function registerEvents() : array
    {
        
        
        return [

           BeforeExport::class => function(BeforeExport $event){

            $event->writer->reopen(new \Maatwebsite\Excel\Files\LocalTemporaryFile(public_path('CS_Form_No._212_Personal_Data_Sheet_revised.xlsx')), \Maatwebsite\Excel\Excel::XLSX);
            
            function get_excel_letter_from_number($num)
            {
                $alphabet = $num % 26;
                $letter = chr(65+$alphabet);
                $store = intval($num / 26 );
                if($store > 0)
                {
                    return get_excel_letter_from_number($store - 1 ) . $letter;
                }

                else
                {
                    return $letter;
                }
            }
            function get_education_array($education_arr){
                
                $educData=[];
                foreach($education_arr as $educ)
                {
                    array_push($educData, [$educ['name'], '','',$educ['basic_education'], '', '', $educ['from'], $educ['to'],
                $educ['highest_level'],$educ['year_graduated'], $educ['scholarship']]);
                };

                return $educData;
            }

            function get_government_array($government_id_arr) {
                $governmentData = [];
                foreach ($government_id_arr as $gov) {
                    if (isset($gov['government_issued_id'], $gov['government_id_no'], $gov['data_place_issuance'])) {
                        $governmentData[] = [
                            'government_issued_id' => $gov['government_issued_id'],
                            'government_id_no' => $gov['government_id_no'],
                            'data_place_issuance' => $gov['data_place_issuance']
                        ];
                    }
                }
                return $governmentData;
            }

            function post_null_arr($arr_null, $event, $sheet_no, $cell_no){
                if($arr_null)
                {
                    $event->getWriter()->getSheetByName($sheet_no)->fromArray($arr_null[0], NULL, $cell_no);
                }
                else
                {
                    $event->getWriter()->getSheetByName($sheet_no)->fromArray([], NULL, $cell_no);
                }
                
                return $event; 
            }

            function post_null_string($str_null, $str_value, $event, $pds , $sheet_indx, $cell_no){

                
                if(isset($pds[$str_null][$str_value]))
                {
                    $event->getWriter()->getSheet($sheet_indx)->setCellValue($cell_no, $pds[$str_null][$str_value]);
                }
                else
                {
                    $event->getWriter()->getSheet($sheet_indx)->setCellValue($cell_no, ' ');
                }

            return $event;
            }

            // III. EDUCATIONAL BACKGROUND

            $childData = [];
            $childData1 = [];
            $childIndex = 0;
            $child_loop = ceil(count($this->pds['children']) / 12);

            $elem_loop = count($this->pds['elementary']);
            $second_loop = count($this->pds['secondary']);
            $vocation_loop = count($this->pds['vocational']);
            $coll_loop = count($this->pds['college']);
            $grad_loop = count($this->pds['graduate']);
            

            $loopingC1 = max($child_loop, $elem_loop, $second_loop, $vocation_loop, $coll_loop, $grad_loop );
            if($loopingC1 == 0)
            {
                $loopingC1 = max($child_loop, $elem_loop, $second_loop, $vocation_loop, $coll_loop, $grad_loop );
                if($loopingC1 == 1)
                {
                    $loopingC1 = max($child_loop, $elem_loop, $second_loop, $vocation_loop, $coll_loop, $grad_loop ) - 1; 
                }
            }


            foreach($this->pds['children'] as $child){
                if($childIndex % 12 == 0 && $childIndex != 0 )
                {
                    array_push($childData1, $childData);
                    $childData = [];
                }

                array_push($childData, [$child['children_name'], ' ', ' ', ' ',$child['date_of_birth'] ]);

                if($childIndex == count($this->pds['children']) - 1 )
                {
                    array_push($childData1, $childData);
                }

                    $childIndex++;
            };
            
            $elemData= get_education_array($this->pds['elementary']);
            $secondData = get_education_array($this->pds['secondary']);
            $vocationData = get_education_array($this->pds['vocational']);
            $collData = get_education_array($this->pds['college']);
            $gradData = get_education_array($this->pds['graduate']);

                for($i = 0; $i < $loopingC1; $i++)
                {   
                    if($i == 0)
                    {
                        $clonedWorksheet = clone $event->getWriter()->getSheetByName('C1');
                        post_null_arr($childData1, $event, 'C1' , 'I37');
                        post_null_arr($elemData, $event, 'C1' , 'D54');
                        post_null_arr($secondData, $event, 'C1' , 'D55');
                        post_null_arr($vocationData, $event, 'C1' , 'D56');
                        post_null_arr($collData, $event, 'C1' , 'D57');
                        post_null_arr($gradData, $event, 'C1' , 'D58');
                    }

                    else
                    {
                        $clonedWorksheet = clone $event->getWriter()->getSheetByName('C1-Duplicate-'. strval($i));
                    }

                if($loopingC1 > 1 && $i != $loopingC1 - 1)
                {
                    $clonedWorksheet->setTitle('C1-Duplicate-'. strval($i+1));
                    $event->getWriter()->addSheet($clonedWorksheet);

                    if($i < $child_loop -1)
                    {
                        $event->getWriter()->getSheetByName('C1-Duplicate-'.strval($i+1))->fromArray($childData1[$i+1], NULL, 'I37');
                    }

                    else 
                    {
                        for($y=37; $y < 49; $y++){
                            $event->getWriter()->getSheetByName('C1-Duplicate-'.strval($i+1))->setCellValue('I'.$y, " ");
                            $event->getWriter()->getSheetByName('C1-Duplicate-'.strval($i+1))->setCellValue('M'.$y , " ");
                        }   
                    }

                    if($i < $elem_loop -1)
                    {
                        $event->getWriter()->getSheetByName('C1-Duplicate-'.strval($i+1))->fromArray($elemData[$i+1], NULL, 'D54');
                    }

                    else
                    {
                        for($y=3; $y < 14 ; $y++){
                            $event->getWriter()->getSheetByName('C1-Duplicate-'.strval($i+1))->setCellValue(get_excel_letter_from_number($y).'54' , "  ");
                        } 
                    }
                    
                    if($i < $second_loop -1)
                    {
                        $event->getWriter()->getSheetByName('C1-Duplicate-'.strval($i+1))->fromArray($secondData[$i+1], NULL, 'D55');
                    }

                    else
                    {
                        for($y=3; $y < 14 ; $y++){
                            $event->getWriter()->getSheetByName('C1-Duplicate-'.strval($i+1))->setCellValue(get_excel_letter_from_number($y).'55' , "  ");
                        } 
                    }

                    if($i < $vocation_loop -1)
                    {
                        $event->getWriter()->getSheetByName('C1-Duplicate-'.strval($i+1))->fromArray($vocationData[$i+1], NULL, 'D56');
                    }

                    else
                    {
                        for($y=3; $y < 14 ; $y++){
                            $event->getWriter()->getSheetByName('C1-Duplicate-'.strval($i+1))->setCellValue(get_excel_letter_from_number($y).'56' , "  ");
                        } 
                    }

                    if($i < $coll_loop -1)
                    {
                        $event->getWriter()->getSheetByName('C1-Duplicate-'.strval($i+1))->fromArray($collData[$i+1], NULL, 'D57');
                    }
                    else
                    {
                        for($y=3; $y < 14 ; $y++){
                            $event->getWriter()->getSheetByName('C1-Duplicate-'.strval($i+1))->setCellValue(get_excel_letter_from_number($y).'57' , "  ");
                        } 
                    }

                    if($i < $grad_loop -1)
                    {
                        $event->getWriter()->getSheetByName('C1-Duplicate-'.strval($i+1))->fromArray($gradData[$i+1], NULL, 'D58');
                    }

                    else
                    {
                        for($y=3; $y < 14 ; $y++){
                            $event->getWriter()->getSheetByName('C1-Duplicate-'.strval($i+1))->setCellValue(get_excel_letter_from_number($y).'58' , "  ");
                        } 
                    }
                }  
            };
    
            // IV. CIVIL SERVICE ELEGIBILITY  && V. WORK EXPERIENCE

            $civilData = [];
            $civilData1 = [];
            $civilIndex = 0;
            $civil_loop = ceil(count($this->pds['civil_service']) / 7);

            $workData = [];
            $workData1 = [];
            $workIndex = 0;
            $work_loop = ceil(count($this->pds['work_experience']) / 28);

            $loopingC2 = max($civil_loop, $work_loop);
            if($loopingC2 == 0)
            {
                $loopingC2 = max($civil_loop, $work_loop);
                if($loopingC2 == 1)
                {
                    $loopingC2 = max($civil_loop, $work_loop) - 1; 
                }
            }

            //civilservice
            foreach($this->pds['civil_service'] as $civil){
                if($civilIndex % 7 == 0 && $civilIndex != 0 )
                {
                    array_push($civilData1, $civilData);
                    $civilData = [];
                }

                array_push($civilData, [$civil['career_service'], ' ', ' ', ' ', '', $civil['rating'], $civil['date_examination'],
                '',$civil['place_examination'], '','', $civil['license_number'], $civil['date_validity'] ]);

                if($civilIndex == count($this->pds['civil_service']) - 1 )
                {
                    array_push($civilData1, $civilData);
                }

                    $civilIndex++;
            };

            //workexperience
            foreach($this->pds['work_experience'] as $work){
                if($workIndex % 28 == 0 && $workIndex != 0 )
                {
                    array_push($workData1, $workData);
                    $workData = [];
                }

                array_push($workData, [$work['from'], ' ', $work['to'], $work['position'],' ', ' ', $work['department'], ' ', ' ',
                $work['monthly_salary'],$work['salary_grade'], $work['status_appointment'], $work['government_service'] ]);

                if($workIndex == count($this->pds['work_experience']) - 1 )
                {
                    array_push($workData1, $workData);
                }

                    $workIndex++;
            };

            for($i = 0; $i < $loopingC2; $i++)
                {   
                    if($i == 0)
                    {
                        $clonedWorksheet = clone $event->getWriter()->getSheetByName('C2');

                        post_null_arr($civilData1, $event, 'C2' , 'A5');
                        post_null_arr($workData1, $event, 'C2' , 'A18');
                    }

                    else
                    {
                        $clonedWorksheet = clone $event->getWriter()->getSheetByName('C2-Duplicate-'. strval($i));
                    }

                    if($loopingC2 > 1 && $i != $loopingC2 - 1)
                    {

                        
                        $clonedWorksheet->setTitle('C2-Duplicate-'. strval($i+1));
                        $event->getWriter()->addSheet($clonedWorksheet);

                        
                        if($i < $civil_loop - 1)
                        {
                            $event->getWriter()->getSheetByName('C2-Duplicate-'.strval($i+1))->fromArray($civilData1[$i+1], NULL, 'A5');
                        }

                        else 
                        {
                            for($y=5; $y < 12; $y++){
                                $event->getWriter()->getSheetByName('C2-Duplicate-'.strval($i+1))->setCellValue('A'.$y, " ");
                                $event->getWriter()->getSheetByName('C2-Duplicate-'.strval($i+1))->setCellValue('F'.$y , " ");
                                $event->getWriter()->getSheetByName('C2-Duplicate-'.strval($i+1))->setCellValue('G'.$y , " ");
                                $event->getWriter()->getSheetByName('C2-Duplicate-'.strval($i+1))->setCellValue('I'.$y , " ");
                                $event->getWriter()->getSheetByName('C2-Duplicate-'.strval($i+1))->setCellValue('L'.$y , " ");
                                $event->getWriter()->getSheetByName('C2-Duplicate-'.strval($i+1))->setCellValue('M'.$y , " ");
                            }   
                        }

                        if($i < $work_loop - 1)
                        {
                            $event->getWriter()->getSheetByName('C2-Duplicate-'.strval($i+1))->fromArray($workData1[$i+1], NULL, 'A18');
                        }

                        else 
                        {
                            for($y=18; $y < 46; $y++){
                                $event->getWriter()->getSheetByName('C2-Duplicate-'.strval($i+1))->setCellValue('A'.$y, " ");
                                $event->getWriter()->getSheetByName('C2-Duplicate-'.strval($i+1))->setCellValue('C'.$y , " ");
                                $event->getWriter()->getSheetByName('C2-Duplicate-'.strval($i+1))->setCellValue('D'.$y , " ");
                                $event->getWriter()->getSheetByName('C2-Duplicate-'.strval($i+1))->setCellValue('G'.$y , " ");
                                $event->getWriter()->getSheetByName('C2-Duplicate-'.strval($i+1))->setCellValue('J'.$y , " ");
                                $event->getWriter()->getSheetByName('C2-Duplicate-'.strval($i+1))->setCellValue('K'.$y , " ");
                                $event->getWriter()->getSheetByName('C2-Duplicate-'.strval($i+1))->setCellValue('L'.$y , " ");
                                $event->getWriter()->getSheetByName('C2-Duplicate-'.strval($i+1))->setCellValue('M'.$y , " ");
                            }   
                        }
                    }
            }


            


            // VI. VOLUNTARY WORK OR INVOLVEMENT IN CIVIC / NON-GOVERNMENT / PEOPLE / VOLUNTARY ORGANIZATION/S
            // VII.  LEARNING AND DEVELOPMENT (L&D) INTERVENTIONS/TRAINING PROGRAMS ATTENDED
            // VIII.  OTHER INFORMATION

            $volunteerData = [];
            $volunteerData1 = [];
            $volunteerIndex = 0;
            $volunteer_loop = ceil(count($this->pds['voluntary_work']) / 7);

            $learningData = [];
            $learningData1 = [];
            $learningIndex = 0;
            $learning_loop = ceil(count($this->pds['learning_development']) / 21);

            $skillData = [];
            $skillData1 = [];
            $skillIndex = 0;
            $skill_loop = ceil(count($this->pds['skill_hobby']) / 7);

            $loopingC3 = max($volunteer_loop, $learning_loop, $skill_loop) ;
            if($loopingC3 == 0)
            {
                $loopingC3 = max($volunteer_loop, $learning_loop, $skill_loop);
                if($loopingC3 == 1)
                {
                    $loopingC3 = max($volunteer_loop, $learning_loop, $skill_loop) - 1; 
                }
            }
            

            // voluntarywork
            foreach($this->pds['voluntary_work'] as $volunteer){
                if($volunteerIndex % 7 == 0 && $volunteerIndex != 0 )
                {
                    array_push($volunteerData1, $volunteerData);
                    $volunteerData = [];
                }

                array_push($volunteerData, [$volunteer['voluntary_name'], ' ', ' ', ' ', $volunteer['from'], 
                $volunteer['to'], $volunteer['number_of_hours'], $volunteer['position']]);

                if($volunteerIndex == count($this->pds['voluntary_work']) - 1 )
                {
                    array_push($volunteerData1, $volunteerData);
                }

                    $volunteerIndex++;
            };

            //learningdevelopment
            foreach($this->pds['learning_development'] as $learn){
                if($learningIndex % 21 == 0 && $learningIndex != 0 )
                {
                    array_push($learningData1, $learningData);
                    $learningData = [];
                }

                array_push($learningData, [$learn['title_learning'], ' ', ' ', ' ', $learn['from'], 
                $learn['to'], $learn['number_of_hours'], $learn['type_of_learning'], $learn['conducted_sponsored_by']]);

                if($learningIndex == count($this->pds['learning_development']) - 1 )
                {
                    array_push($learningData1, $learningData);
                }

                    $learningIndex++;
            };

            //otherinformation
            foreach($this->pds['skill_hobby'] as $skill){
                if($skillIndex % 21 == 0 && $skillIndex != 0 )
                {
                    array_push($skillData1, $skillData);
                    $skillData = [];
                }

                array_push($skillData, [$skill['special_skills_hobbies'], ' ', $skill['recognition'], 
                ' ', ' ', ' ', ' ', ' ',  $skill['membership_association'] ]);

                if($skillIndex == count($this->pds['skill_hobby']) - 1 )
                {
                    array_push($skillData1, $skillData);
                }

                    $skillIndex++;
            };
            

            for($i = 0; $i < $loopingC3; $i++)
                {  
                   
                    if($i == 0)
                    {
                        $clonedWorksheet = clone $event->getWriter()->getSheetByName('C3');
                        post_null_arr($volunteerData1, $event, 'C3' , 'A6');
                        post_null_arr($learningData1, $event, 'C3' , 'A18');
                        post_null_arr($skillData1, $event, 'C3' , 'A42');
                    }
                    
                    else
                    {
                        $clonedWorksheet = clone $event->getWriter()->getSheetByName('C3-Duplicate-'. strval($i));
                    }
                   
                if($loopingC3 > 1 && $i != $loopingC3 - 1)
                {
                    $clonedWorksheet->setTitle('C3-Duplicate-'. strval($i+1));
                    $event->getWriter()->addSheet($clonedWorksheet);

                    if($i < $volunteer_loop - 1)
                    {
                        $event->getWriter()->getSheetByName('C3-Duplicate-'.strval($i+1))->fromArray($volunteerData1[$i+1], NULL, 'A6');
                    }

                    else 
                    {
                        for($y=6; $y < 13; $y++){
                            $event->getWriter()->getSheetByName('C3-Duplicate-'.strval($i+1))->setCellValue('A'.$y, " ");
                            $event->getWriter()->getSheetByName('C3-Duplicate-'.strval($i+1))->setCellValue('E'.$y , " ");
                            $event->getWriter()->getSheetByName('C3-Duplicate-'.strval($i+1))->setCellValue('F'.$y , " ");
                            $event->getWriter()->getSheetByName('C3-Duplicate-'.strval($i+1))->setCellValue('G'.$y , " ");
                            $event->getWriter()->getSheetByName('C3-Duplicate-'.strval($i+1))->setCellValue('H'.$y , " ");

                        }   
                    }

                    if($i < $learning_loop - 1)
                    {
                        $event->getWriter()->getSheetByName('C3-Duplicate-'.strval($i+1))->fromArray($learningData1[$i+1], NULL, 'A18');
                    }

                    else 
                    {
                        for($y=18; $y < 39; $y++){
                            $event->getWriter()->getSheetByName('C3-Duplicate-'.strval($i+1))->setCellValue('A'.$y, " ");
                            $event->getWriter()->getSheetByName('C3-Duplicate-'.strval($i+1))->setCellValue('E'.$y , " ");
                            $event->getWriter()->getSheetByName('C3-Duplicate-'.strval($i+1))->setCellValue('F'.$y , " ");
                            $event->getWriter()->getSheetByName('C3-Duplicate-'.strval($i+1))->setCellValue('G'.$y , " ");
                            $event->getWriter()->getSheetByName('C3-Duplicate-'.strval($i+1))->setCellValue('H'.$y , " ");
                            $event->getWriter()->getSheetByName('C3-Duplicate-'.strval($i+1))->setCellValue('I'.$y , " ");

                        }   
                    }


                    if($i < $skill_loop - 1)
                    {
                        $event->getWriter()->getSheetByName('C3-Duplicate-'.strval($i+1))->fromArray($skillData1[$i+1], NULL, 'A42');
                    }

                    else 
                    {
                        for($y=18; $y < 39; $y++){
                            $event->getWriter()->getSheetByName('C3-Duplicate-'.strval($i+1))->setCellValue('A'.$y, " ");
                            $event->getWriter()->getSheetByName('C3-Duplicate-'.strval($i+1))->setCellValue('C'.$y , " ");
                            $event->getWriter()->getSheetByName('C3-Duplicate-'.strval($i+1))->setCellValue('I'.$y , " ");


                        }   
                    }
                }
            }

            //I. PERSONAL INFORMATION
            post_null_string('personal_information', 'last_name' ,$event, $this->pds ,0 , 'D10');
            post_null_string('personal_information', 'first_name' ,$event, $this->pds ,0 , 'D11');
            post_null_string('personal_information', 'middle_name' ,$event, $this->pds ,0 , 'D12');
            post_null_string('personal_information', 'date_of_birth' ,$event, $this->pds ,0 , 'D13');
            post_null_string('personal_information', 'place_of_birth' ,$event, $this->pds ,0 , 'D15');

            // Funtion for Checkbox sex
            if(isset($this->pds['pds_choices']['sex']))
            {   
                $sex = $this->pds['pds_choices']['sex'];
                if($sex == "Male")
                {
                    $event->getWriter()->getSheet(0)->setCellValue('D16', "     ☑ Male                 ☐ Female" );
                }
                else
                {
                    $event->getWriter()->getSheet(0)->setCellValue('D16', "     ☐ Male                 ☑ Female" );
                }
            }

            else
            {
                $event->getWriter()->getSheet(0)->setCellValue('D16', "     ☐ Male                 ☐ Female" );   
            }

            // Funtion for Checkbox civil_status
            
            if(isset($this->pds['pds_choices']['civil_status']))
            {
                $civil = $this->pds['pds_choices']['civil_status'];
                if($civil == "single")
                {
                    $event->getWriter()->getSheet(0)->setCellValue('D17', "     ☑ Single                 ☐ Married                 
                ☐ Widowed                 ☐ Seperated                 ☐ Other/s:  " );
                }
                elseif($civil == "married")
                {
                    $event->getWriter()->getSheet(0)->setCellValue('D17', "     ☐ Single                 ☑ Married                 
                ☐ Widowed                 ☐ Seperated                 ☐ Other/s:  " );
                }
                elseif($civil == "widowed")
                {
                    $event->getWriter()->getSheet(0)->setCellValue('D17', "     ☐ Single                 ☐ Married                 
                ☑ Widowed                 ☐ Seperated                 ☐ Other/s:  " );
                }
                elseif($civil == "seperated")
                {
                    $event->getWriter()->getSheet(0)->setCellValue('D17', "     ☐ Single                 ☐ Married                 
                ☐ Widowed                 ☑ Seperated                 ☐ Other/s:  " );
                }
                else
                {
                    $event->getWriter()->getSheet(0)->setCellValue('D17', "     ☐ Single                 ☐ Married                 
                ☐ Widowed                 ☐ Seperated                 ☑ Other/s:  " );
                }

            }

            else
            {
                $event->getWriter()->getSheet(0)->setCellValue('D17', "     ☐ Single                 ☐ Married                 
                ☐ Widowed                 ☐ Seperated                 ☐ Other/s:  " );
            }

            
            

            
            // $event->getWriter()->getSheet(0)->setCellValue('D17', $this->pds['pds_choices']['civil_status']);


            post_null_string('other_information', 'height' ,$event, $this->pds ,0 , 'D22');
            post_null_string('other_information', 'weight' ,$event, $this->pds ,0 , 'D24');
            post_null_string('other_information', 'blood_type' ,$event, $this->pds ,0 , 'D25');
            post_null_string('personal_information', 'gsis_id' ,$event, $this->pds ,0 , 'D27');
            post_null_string('personal_information', 'pagibig_no' ,$event, $this->pds ,0 , 'D29');
            post_null_string('personal_information', 'philhealth_id' ,$event, $this->pds ,0 , 'D31');
            post_null_string('personal_information', 'sss_id' ,$event, $this->pds ,0 , 'D32');
            post_null_string('personal_information', 'tin_id' ,$event, $this->pds ,0 , 'D33');
            post_null_string('personal_information', 'employee_no' ,$event, $this->pds ,0 , 'D34');
            post_null_string('personal_information', 'name_extension' ,$event, $this->pds ,0 , 'M11');

            // Funtion for Checkbox citizenship
            $citizen = $this->pds['pds_choices']['citizenship'];
            if(isset($citizen))
            {
                
                if($citizen == "Filipino")
                {
                    $event->getWriter()->getSheet(0)->setCellValue('J13', "     ☑ Filipino                  ☐ Dual Citizenship                 
                ☐ by Birth                 ☐ by Naturalization               " );
                }
                elseif($citizen == "Dual Citizenship")
                {
                    $event->getWriter()->getSheet(0)->setCellValue('J13', "     ☐ Filipino                  ☑ Dual Citizenship                 
                ☐ by Birth                 ☐ by Naturalization               " );
                }
                elseif($citizen == "By Birth")
                {
                    $event->getWriter()->getSheet(0)->setCellValue('J13', "     ☐ Filipino                  ☐ Dual Citizenship                 
                ☑ by Birth                 ☐ by Naturalization               " );
                }
                else
                {
                    $event->getWriter()->getSheet(0)->setCellValue('J13', "     ☐ Filipino                  ☐ Dual Citizenship                 
                ☐ by Birth                 ☑ by Naturalization               " );
                }
            }

            else
            {
                $event->getWriter()->getSheet(0)->setCellValue('J13', "     ☐ Filipino                  ☐ Dual Citizenship                 
                ☐ by Birth                 ☐ by Naturalization               " );
            }
            
            post_null_string('residential_address', 'house_block_lot_no' ,$event, $this->pds ,0 , 'I17');
            post_null_string('residential_address', 'subdivision_village' ,$event, $this->pds ,0 , 'I19');
            post_null_string('residential_address', 'city_municipality' ,$event, $this->pds ,0 , 'I22');
            post_null_string('residential_address', 'street' ,$event, $this->pds ,0 , 'L17');
            post_null_string('residential_address', 'barangay' ,$event, $this->pds ,0 , 'L19');
            post_null_string('residential_address', 'province' ,$event, $this->pds ,0 , 'L22');
            post_null_string('residential_address', 'zip_code' ,$event, $this->pds ,0 , 'I24');
            post_null_string('permanent_address', 'house_block_lot_no' ,$event, $this->pds ,0 , 'I25');
            post_null_string('permanent_address', 'subdivision_village' ,$event, $this->pds ,0 , 'I27');
            post_null_string('permanent_address', 'city_municipality' ,$event, $this->pds ,0 , 'I29');
            post_null_string('permanent_address', 'street' ,$event, $this->pds ,0 , 'L25');
            post_null_string('permanent_address', 'barangay' ,$event, $this->pds ,0 , 'L27');
            post_null_string('permanent_address', 'province' ,$event, $this->pds ,0 , 'L29');
            post_null_string('permanent_address', 'zip_code' ,$event, $this->pds ,0 , 'I31');
            post_null_string('other_information', 'telephone_no' ,$event, $this->pds ,0 , 'I32');
            post_null_string('other_information', 'mobile_no' ,$event, $this->pds ,0 , 'I33');
            post_null_string('personal_information', 'email' ,$event, $this->pds ,0 , 'I34');

            // II. FAMILY BACKGROUND
            post_null_string('spouse', 'last_name' ,$event, $this->pds ,0 , 'D36');
            post_null_string('spouse', 'first_name' ,$event, $this->pds ,0 , 'D37');
            post_null_string('spouse', 'name_extension' ,$event, $this->pds ,0 , 'H37');
            post_null_string('spouse', 'middle_name' ,$event, $this->pds ,0 , 'D38');
            post_null_string('spouse', 'occupation' ,$event, $this->pds ,0 , 'D39');
            post_null_string('spouse', 'employer_business_name' ,$event, $this->pds ,0 , 'D40');
            post_null_string('spouse', 'business_address' ,$event, $this->pds ,0 , 'D41');
            post_null_string('spouse', 'telephone_no' ,$event, $this->pds ,0 , 'D42');
            post_null_string('father', 'last_name' ,$event, $this->pds ,0 , 'D43');
            post_null_string('father', 'first_name' ,$event, $this->pds ,0 , 'D44');
            post_null_string('father', 'name_extension' ,$event, $this->pds ,0 , 'H44');
            post_null_string('father', 'middle_name' ,$event, $this->pds ,0 , 'D45');
            post_null_string('maiden_name', 'last_name' ,$event, $this->pds ,0 , 'D47');
            post_null_string('maiden_name', 'first_name' ,$event, $this->pds ,0 , 'D48');
            post_null_string('maiden_name', 'middle_name' ,$event, $this->pds ,0 , 'D49');

            // REFERENCE

            $referData = [];

            foreach($this->pds['reference'] as $refer){

                array_push($referData, [$refer['name'], ' ', ' ', ' ', ' ', $refer['address'], 
                $refer['tel_no'] ]);
                    
            };

            
            // 34. Q/A
            
            
            if(isset($this->pds['choice']['thirty_four_a']))
            {
                $thirthy_four_a = $this->pds['choice']['thirty_four_a'];

                if($thirthy_four_a == "yes")
                {
                    $event->getWriter()->getSheet(3)->setCellValue('G6', "     ☑ Yes                 ☐ No" );
                }
                else
                {
                    $event->getWriter()->getSheet(3)->setCellValue('G6', "     ☐ Yes                 ☑ No" );
                }
            }

            else 
            {
                $event->getWriter()->getSheet(3)->setCellValue('G6', "     ☐ Yes                 ☐ No" );
            }
            
           
            ;
            if(isset($this->pds['choice']['thirty_four_b']) )
            {
                $thirthy_four_b = $this->pds['choice']['thirty_four_b'];
                
                if($thirthy_four_b == "yes")
                {
                    $event->getWriter()->getSheet(3)->setCellValue('G8', "     ☑ Yes                 ☐ No" );
                }
                else
                {
                    $event->getWriter()->getSheet(3)->setCellValue('G8', "     ☐ Yes                 ☑ No" );
                }
            }

            else
            {
                $event->getWriter()->getSheet(3)->setCellValue('G8', "     ☐ Yes                 ☐ No" );
            }
            
            post_null_string('choice', 'thirty_four_a_details' ,$event, $this->pds ,3 , 'K10');
            post_null_string('choice', 'thirty_four_b_details' ,$event, $this->pds ,3 , 'G11');
            // $event->getWriter()->getSheet(3)->setCellValue('K10', $this->pds['choice']['thirty_four_a_details']);
            // $event->getWriter()->getSheet(3)->setCellValue('G11', $this->pds['choice']['thirty_four_b_details']);

            // 35. Q/A

            
            if(isset($this->pds['choice']['thirty_five_a']) )
            {
                $thirty_five_a = $this->pds['choice']['thirty_five_a'];
                if($thirty_five_a == "yes")
                {
                    $event->getWriter()->getSheet(3)->setCellValue('G13', "     ☑ Yes                 ☐ No" );
                }
                else
                {
                    $event->getWriter()->getSheet(3)->setCellValue('G13', "     ☐ Yes                 ☑ No" );
                }
            }

            else
            {
                $event->getWriter()->getSheet(3)->setCellValue('G13', "     ☐ Yes                 ☐ No" );
            }

            post_null_string('choice', 'thirty_five_a_details' ,$event, $this->pds ,3 , 'H15');

            if(isset($this->pds['choice']['thirty_five_b']) )
            {
                $thirty_five_b = $this->pds['choice']['thirty_five_b'];
                if($thirty_five_b == "yes")
                {
                    $event->getWriter()->getSheet(3)->setCellValue('G17', "     ☑ Yes                 ☐ No" );
                }
                else
                {
                    $event->getWriter()->getSheet(3)->setCellValue('G17', "     ☐ Yes                 ☑ No" );
                }
            }

            else 
            {
                $event->getWriter()->getSheet(3)->setCellValue('G17', "     ☐ Yes                 ☐ No" );
            }

            post_null_string('choice', 'thirty_five_b_details' ,$event, $this->pds ,3 , 'G21');

            // 36. Q/A
            
            if(isset( $this->pds['choice']['thirty_six']) )
            {   
                $thirty_six = $this->pds['choice']['thirty_six'];
                if($thirty_six == "yes")
                {
                    $event->getWriter()->getSheet(3)->setCellValue('G23', "     ☑ Yes                 ☐ No" );
                }
                else
                {
                    $event->getWriter()->getSheet(3)->setCellValue('G23', "     ☐ Yes                 ☑ No" );
                }
            }

            else
            {
                $event->getWriter()->getSheet(3)->setCellValue('G23', "     ☐ Yes                 ☐ No" );
            }
            
            
            post_null_string('choice', 'thirty_six_details' ,$event, $this->pds ,3 , 'H25');

            // 37. Q/A

            
            if(isset($this->pds['choice']['thirty_seven']) )
            {
                $thirty_seven = $this->pds['choice']['thirty_seven'];
                if($thirty_seven == "yes")
                {
                    $event->getWriter()->getSheet(3)->setCellValue('G27', "     ☑ Yes                 ☐ No" );
                }
                else
                {
                    $event->getWriter()->getSheet(3)->setCellValue('G27', "     ☐ Yes                 ☑ No" );
                }
            }
            
            else
            {
                $event->getWriter()->getSheet(3)->setCellValue('G27', "     ☐ Yes                 ☐ No" );
            }
            

            post_null_string('choice', 'thirty_seven_details' ,$event, $this->pds ,3 , 'G29');

            // 38. Q/A
           
            if(isset($this->pds['choice']['thirty_eight_a']) )
            {
                $thirty_eight_a = $this->pds['choice']['thirty_eight_a'];
                if($thirty_eight_a == "yes")
                {
                    $event->getWriter()->getSheet(3)->setCellValue('G31', "     ☑ Yes                 ☐ No" );
                }
                else
                {
                    $event->getWriter()->getSheet(3)->setCellValue('G31', "     ☐ Yes                 ☑ No" );
                }

            }

            else
            {
                $event->getWriter()->getSheet(3)->setCellValue('G31', "     ☐ Yes                 ☐ No" );
            }
            
            post_null_string('choice', 'thirty_eight_a_details' ,$event, $this->pds ,3 , 'K32');  

            if(isset($this->pds['choice']['thirty_eight_b']) )
            {
                $thirty_eight_b = $this->pds['choice']['thirty_eight_b'];
                if($thirty_eight_b == "yes")
                {
                    $event->getWriter()->getSheet(3)->setCellValue('G34', "     ☑ Yes                 ☐ No" );
                }
                else
                {
                    $event->getWriter()->getSheet(3)->setCellValue('G34', "     ☐ Yes                 ☑ No" );
                }
            }

            else
            {
                $event->getWriter()->getSheet(3)->setCellValue('G34', "     ☐ Yes                 ☐ No" );
            }

            

            post_null_string('choice', 'thirty_eight_b_details' ,$event, $this->pds ,3 , 'K35');
            // 39. Q/A
            
            if(isset($this->pds['choice']['thirty_nine']) )
            {
                $thirty_nine = $this->pds['choice']['thirty_nine'];
                if($thirty_nine == "yes")
                {
                    $event->getWriter()->getSheet(3)->setCellValue('G37', "     ☑ Yes                 ☐ No" );
                }
                else
                {
                    $event->getWriter()->getSheet(3)->setCellValue('G37', "     ☐ Yes                 ☑ No" );
                }

            }
                else
                {
                    $event->getWriter()->getSheet(3)->setCellValue('G37', "     ☐ Yes                 ☐ No" );
                }
            post_null_string('choice', 'thirty_nine_details' ,$event, $this->pds ,3 , 'H39');

            // 40. Q/A
            if(isset($this->pds['choice']['forty_a']) )
            {
                $forty_a = $this->pds['choice']['forty_a'];
                if($forty_a == "yes")
                {
                    $event->getWriter()->getSheet(3)->setCellValue('G43', "     ☑ Yes                 ☐ No" );
                }
                else
                {
                    $event->getWriter()->getSheet(3)->setCellValue('G43', "     ☐ Yes                 ☑ No" );
                }
            }
            else
            {
                $event->getWriter()->getSheet(3)->setCellValue('G43', "     ☐ Yes                 ☐ No" );
            }

            
            
            post_null_string('choice', 'forty_a_details' ,$event, $this->pds ,3 , 'K44');

            if(isset($this->pds['choice']['forty_b']) )
            {
                $forty_b = $this->pds['choice']['forty_b'];
                if($forty_b == "yes")
                {
                    $event->getWriter()->getSheet(3)->setCellValue('G45', "     ☑ Yes                 ☐ No" );
                }
                else
                {
                    $event->getWriter()->getSheet(3)->setCellValue('G45', "     ☐ Yes                 ☑ No" );
                }

            }

            else
            {
                $event->getWriter()->getSheet(3)->setCellValue('G45', "     ☐ Yes                 ☐ No" );
            }
            
            
            post_null_string('choice', 'forty_b_details' ,$event, $this->pds ,3 , 'K46');

            if(isset($this->pds['choice']['forty_c']) )
            {
                $forty_c = $this->pds['choice']['forty_c'];
                if($forty_c == "yes")
                {
                    $event->getWriter()->getSheet(3)->setCellValue('G47', "     ☑ Yes                 ☐ No" );
                }
                else
                {
                    $event->getWriter()->getSheet(3)->setCellValue('G47', "     ☐ Yes                 ☑ No" );
                }

            }

            else
            {
                $event->getWriter()->getSheet(3)->setCellValue('G47', "     ☐ Yes                 ☐ No" );
            }
            post_null_string('choice', 'forty_c_details' ,$event, $this->pds ,3 , 'K48');

            $event->getWriter()->getSheet(3)->fromArray($referData, NULL, 'A52');

                $governmentData = get_government_array($this->pds['government_issued_id']);
                $numberOfIDs = count($governmentData);

                for ($i = 0; $i < $numberOfIDs; $i++) {
                    if ($i == 0) {
                        $clonedWorksheet = clone $event->getWriter()->getSheetByName('C4');
                        $governmentID = $this->pds['government_issued_id'][0];
                        if (isset($governmentID['government_issued_id'])) {
                            $event->getWriter()->getSheet(3)->setCellValue('D61', $governmentID['government_issued_id']);
                        }

                        if (isset($governmentID['government_id_no'])) {
                            $event->getWriter()->getSheet(3)->setCellValue('D62', $governmentID['government_id_no']);
                        }

                        if (isset($governmentID['data_place_issuance'])) {
                            $event->getWriter()->getSheet(3)->setCellValue('D64', $governmentID['data_place_issuance']);
                        }
                    } else {
                        $clonedWorksheet = clone $event->getWriter()->getSheetByName('C4');
                        $clonedWorksheet->setTitle('C4-Duplicate-' . strval($i));
                        $event->getWriter()->addSheet($clonedWorksheet);
                    }

                    $governmentID = $governmentData[$i];

                    if (isset($governmentID['government_issued_id'])) {
                        $clonedWorksheet->setCellValue('D61', $governmentID['government_issued_id']);
                    }

                    if (isset($governmentID['government_id_no'])) {
                        $clonedWorksheet->setCellValue('D62', $governmentID['government_id_no']);
                    }

                    if (isset($governmentID['data_place_issuance'])) {
                        $clonedWorksheet->setCellValue('D64', $governmentID['data_place_issuance']);
                    }
                }
            },
            
         ];
    }
}
