<?php

namespace Suiterus\Adg\Exports\BCE;

use Suiterus\Adg\Models\SM\Branch;
use Suiterus\Hrjp\Models\Position;
use Suiterus\Hrjp\Models\ItemCode;
use Suiterus\Adg\Models\SM\Division;
use Suiterus\Adg\Models\SM\Department;
use Suiterus\Adg\Models\SM\Corporation;
use Maatwebsite\Excel\Events\AfterSheet;
use PhpOffice\PhpSpreadsheet\NamedRange;
use Suiterus\Adg\Models\SM\EmployeeType;
use Maatwebsite\Excel\Concerns\WithTitle;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Style\Border;
use Illuminate\Database\Eloquent\Collection;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use Maatwebsite\Excel\Concerns\FromCollection;
use PhpOffice\PhpSpreadsheet\Cell\DataValidation;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class EmployeesExportFailureSheet implements FromCollection, WithTitle, WithStyles, WithEvents
{
    private $title;
    private $employees;

    public function __construct($title, $failure)
    {
        $this->title = $title;
        $this->employees = $failure;
    }

    /**
     * @return Builder
     */
    public function collection()
    {
        return new Collection();
    }

    /**
     * @return string
     */
    public function title(): string
    {
        return $this->title;
    }

    public function styles(Worksheet $sheet){

        if ($this->title == "BATCH_EMPLOYEE_ERRORS") {
                // headers
            $sheet->mergeCells('A1:Q1');
            $sheet->mergeCells('R1:X1');
            $sheet->mergeCells('Y1:AC1');
            $sheet->setCellValue('A1', 'General Information');
            $sheet->setCellValue('R1', 'Residential Address');
            $sheet->setCellValue('Y1', 'Corporation & Branches');
            $sheet->getStyle("A1")->getFont()->setBold(true);
            $sheet->getStyle("R1")->getFont()->setBold(true);
            $sheet->getStyle("Y1")->getFont()->setBold(true);

            $style = array(
                'alignment' => array(
                    'horizontal' => Alignment::HORIZONTAL_CENTER
                )
            );
        
            $sheet->getStyle("A1:Q1")->applyFromArray($style);
            $sheet->getStyle("R1:X1")->applyFromArray($style);
            $sheet->getStyle("Y1:AC1")->applyFromArray($style);
            $sheet->getStyle("A:AC")->applyFromArray($style);

            // Column Width
            $sheet->getColumnDimension("A")->setWidth(21.14);
            $sheet->getColumnDimension("B")->setWidth(21.14);
            $sheet->getColumnDimension("C")->setWidth(21.14);
            $sheet->getColumnDimension("D")->setWidth(20.57);
            $sheet->getColumnDimension("E")->setWidth(20.71);
            $sheet->getColumnDimension("F")->setWidth(19.14);
            $sheet->getColumnDimension("G")->setWidth(20.57);
            $sheet->getColumnDimension("H")->setWidth(20.14);
            $sheet->getColumnDimension("I")->setWidth(19.14);
            $sheet->getColumnDimension("J")->setWidth(19.14);
            $sheet->getColumnDimension("K")->setWidth(18.71);
            $sheet->getColumnDimension("L")->setWidth(31.14);
            $sheet->getColumnDimension("M")->setWidth(17.71);
            $sheet->getColumnDimension("N")->setWidth(19.29);
            $sheet->getColumnDimension("O")->setWidth(18.43);
            $sheet->getColumnDimension("P")->setWidth(20.14);
            $sheet->getColumnDimension("Q")->setWidth(20.14);
            $sheet->getColumnDimension("R")->setWidth(20.14);
            $sheet->getColumnDimension("S")->setWidth(20.14);
            $sheet->getColumnDimension("T")->setWidth(20.14);
            $sheet->getColumnDimension("U")->setWidth(20.14);
            $sheet->getColumnDimension("V")->setWidth(20.14);
            $sheet->getColumnDimension("W")->setWidth(18.71);
            $sheet->getColumnDimension("X")->setWidth(17.71);
            $sheet->getColumnDimension("Y")->setWidth(20.86);
            $sheet->getColumnDimension("Z")->setWidth(16.67);
            $sheet->getColumnDimension("AA")->setWidth(18.43);
            $sheet->getColumnDimension("AB")->setWidth(18.43);
            $sheet->getColumnDimension("AC")->setWidth(18.43);
            $sheet->getRowDimension(2)->setRowHeight("35");

            // styling header
            $styleArray = array(
                'borders' => array(
                    'allBorders' => array(
                        'borderStyle' => Border::BORDER_THIN,
                        'color' => array('argb' => '00000000'),
                    ),
                ),
                'alignment' => [
                    'vertical' => Alignment::VERTICAL_CENTER,
                    'horizontal' => Alignment::HORIZONTAL_CENTER,
                    'wrapText' => true
                ],
                ''
            );

            for ($i = 1; $i < count($this->employees) + 3; $i++) { 
                $sheet->getStyle("A" . $i . ":AC" . $i)->applyFromArray($styleArray);
            }

            $sheet->getStyle('L2')->getAlignment()->setWrapText(true);
            $sheet->getStyle('M2')->getAlignment()->setWrapText(true);
            $sheet->getStyle('N2')->getAlignment()->setWrapText(true);


            // body
            $sheet->setCellValue("A2", "Employee Type");
            $sheet->setCellValue("B2", "Position");
            $sheet->setCellValue("C2", "Item Code");
            $sheet->setCellValue("D2", "Employee No.");
            $sheet->setCellValue("E2", "First Name");
            $sheet->setCellValue("F2", "Middle Name");
            $sheet->setCellValue("G2", "Last Name");
            $sheet->setCellValue("H2", "Suffix");
            $sheet->setCellValue("I2", "E-mail");
            $sheet->setCellValue("J2", "Gender");
            $sheet->setCellValue("K2", "Citizenship");
            $sheet->setCellValue("L2", "Citizenship\n(If holder of dual citizenship, please indicate the details)");
            $sheet->setCellValue("M2", "Civil Status");
            $sheet->setCellValue("N2", "Civil Status\n(If Others, please specify)");
            $sheet->setCellValue("O2", "Telephone Number");
            $sheet->setCellValue("P2", "Contact Number");
            $sheet->setCellValue("Q2", "Date of Birth\n(mm/dd/yyyy)");
            $sheet->setCellValue("R2", "Place of Birth");
            $sheet->setCellValue("S2", "House/Block/Lot No.");
            $sheet->setCellValue("T2", "Street");
            $sheet->setCellValue("U2", "Subdivision/Village");
            $sheet->setCellValue("V2", "Barangay");
            $sheet->setCellValue("W2", "City/Municipality");
            $sheet->setCellValue("X2", "Province");
            $sheet->setCellValue("Y2", "Zip Code");
            $sheet->setCellValue("Z2", "Corporation");
            $sheet->setCellValue("AA2", "Branch");
            $sheet->setCellValue("AB2", "Division");
            $sheet->setCellValue("AC2", "Department");
        }
    }

    public function registerEvents(): array{

        //$event = $this->getEvent();
     
        return [
            AfterSheet::class => function (AfterSheet $event) {
                if ($this->title == "BATCH_EMPLOYEE_ERRORS") {
                    /** @var Sheet $sheet */
                    $sheet = $event->sheet;
    
                    /**
                     * validation for bulkuploadsheet
                     */
    
                    // Create a dropdown list validation
                    
                    for ($i = 3; $i < count($this->employees) + 3; $i++) { 

                        $sheet->setCellValue('A'. $i, "Select Employee Type");
                        $cellValidation = $sheet->getCell('A'.$i)->getDataValidation();
                        
                        $cellValidation->setType(DataValidation::TYPE_LIST);
                        $cellValidation->setErrorStyle(DataValidation::STYLE_INFORMATION);
                        $cellValidation->setAllowBlank(false);
                        $cellValidation->setShowInputMessage(true);
                        $cellValidation->setShowErrorMessage(true);
                        $cellValidation->setShowDropDown(true);
                        $cellValidation->setErrorTitle("Input error.");
                        $cellValidation->setError('Value is not in this list.');
                        $cellValidation->setPromptTitle('Chose from list');
                        $cellValidation->setPrompt('Please, chose a value for dropdown list.');
        
                        $cellValidation->setFormula1('=employee_type');

                        $sheet->setCellValue('B'. $i, "Select Position");
                        $cellValidation = $sheet->getCell('B'.$i)->getDataValidation();
                        
                        $cellValidation->setType(DataValidation::TYPE_LIST);
                        $cellValidation->setErrorStyle(DataValidation::STYLE_INFORMATION);
                        $cellValidation->setAllowBlank(false);
                        $cellValidation->setShowInputMessage(true);
                        $cellValidation->setShowErrorMessage(true);
                        $cellValidation->setShowDropDown(true);
                        $cellValidation->setErrorTitle("Input error.");
                        $cellValidation->setError('Value is not in this list.');
                        $cellValidation->setPromptTitle('Chose from list');
                        $cellValidation->setPrompt('Please, chose a value for dropdown list.');
        
                        $cellValidation->setFormula1('=positions');

                        $sheet->setCellValue('C'. $i, "Select Item Code");
                        $cellValidation = $sheet->getCell('C'.$i)->getDataValidation();
                        
                        $cellValidation->setType(DataValidation::TYPE_LIST);
                        $cellValidation->setErrorStyle(DataValidation::STYLE_INFORMATION);
                        $cellValidation->setAllowBlank(false);
                        $cellValidation->setShowInputMessage(true);
                        $cellValidation->setShowErrorMessage(true);
                        $cellValidation->setShowDropDown(true);
                        $cellValidation->setErrorTitle("Input error.");
                        $cellValidation->setError('Value is not in this list.');
                        $cellValidation->setPromptTitle('Chose from list');
                        $cellValidation->setPrompt('Please, chose a value for dropdown list.');
        
                        $cellValidation->setFormula1('=item_codes_list');

                        $sheet->setCellValue('J'. $i, "Select Gender");
                        $cellValidation = $sheet->getCell('J'.$i)->getDataValidation();
                        
                        $cellValidation->setType(DataValidation::TYPE_LIST);
                        $cellValidation->setErrorStyle(DataValidation::STYLE_INFORMATION);
                        $cellValidation->setAllowBlank(false);
                        $cellValidation->setShowInputMessage(true);
                        $cellValidation->setShowErrorMessage(true);
                        $cellValidation->setShowDropDown(true);
                        $cellValidation->setErrorTitle("Input error.");
                        $cellValidation->setError('Value is not in this list.');
                        $cellValidation->setPromptTitle('Chose from list');
                        $cellValidation->setPrompt('Please, chose a value for dropdown list.');
        
                        $cellValidation->setFormula1('=genders_list');

                        $sheet->setCellValue('K'. $i, "Select Citizenship");
                        $cellValidation = $sheet->getCell('K'.$i)->getDataValidation();
                        
                        $cellValidation->setType(DataValidation::TYPE_LIST);
                        $cellValidation->setErrorStyle(DataValidation::STYLE_INFORMATION);
                        $cellValidation->setAllowBlank(false);
                        $cellValidation->setShowInputMessage(true);
                        $cellValidation->setShowErrorMessage(true);
                        $cellValidation->setShowDropDown(true);
                        $cellValidation->setErrorTitle("Input error.");
                        $cellValidation->setError('Value is not in this list.');
                        $cellValidation->setPromptTitle('Chose from list');
                        $cellValidation->setPrompt('Please, chose a value for dropdown list.');
        
                        $cellValidation->setFormula1('=citizenship_list');

                        $sheet->setCellValue('L'. $i, "Select Country");
                        $cellValidation = $sheet->getCell('L'.$i)->getDataValidation();
                        
                        $cellValidation->setType(DataValidation::TYPE_LIST);
                        $cellValidation->setErrorStyle(DataValidation::STYLE_INFORMATION);
                        $cellValidation->setAllowBlank(false);
                        $cellValidation->setShowInputMessage(true);
                        $cellValidation->setShowErrorMessage(true);
                        $cellValidation->setShowDropDown(true);
                        $cellValidation->setErrorTitle("Input error.");
                        $cellValidation->setError('Value is not in this list.');
                        $cellValidation->setPromptTitle('Chose from list');
                        $cellValidation->setPrompt('Please, chose a value for dropdown list.');
        
                        $cellValidation->setFormula1('=INDIRECT($J$'.$i.')');

                        $sheet->setCellValue('M'. $i, "Select Civil Status");
                        $cellValidation = $sheet->getCell('M'.$i)->getDataValidation();
                        
                        $cellValidation->setType(DataValidation::TYPE_LIST);
                        $cellValidation->setErrorStyle(DataValidation::STYLE_INFORMATION);
                        $cellValidation->setAllowBlank(false);
                        $cellValidation->setShowInputMessage(true);
                        $cellValidation->setShowErrorMessage(true);
                        $cellValidation->setShowDropDown(true);
                        $cellValidation->setErrorTitle("Input error.");
                        $cellValidation->setError('Value is not in this list.');
                        $cellValidation->setPromptTitle('Chose from list');
                        $cellValidation->setPrompt('Please, chose a value for dropdown list.');
        
                        $cellValidation->setFormula1('=civil_list');

                        $sheet->setCellValue('Z'. $i, "Select Corporation");
                        $cellValidation = $sheet->getCell('Z'.$i)->getDataValidation();
                        
                        $cellValidation->setType(DataValidation::TYPE_LIST);
                        $cellValidation->setErrorStyle(DataValidation::STYLE_INFORMATION);
                        $cellValidation->setAllowBlank(false);
                        $cellValidation->setShowInputMessage(true);
                        $cellValidation->setShowErrorMessage(true);
                        $cellValidation->setShowDropDown(true);
                        $cellValidation->setErrorTitle("Input error.");
                        $cellValidation->setError('Value is not in this list.');
                        $cellValidation->setPromptTitle('Chose from list');
                        $cellValidation->setPrompt('Please, chose a value for dropdown list.');
        
                        $cellValidation->setFormula1('=corporations_list');

                        $sheet->setCellValue('AA'. $i, "Select Branch");
                        $cellValidation = $sheet->getCell('AA'.$i)->getDataValidation();
                        
                        $cellValidation->setType(DataValidation::TYPE_LIST);
                        $cellValidation->setErrorStyle(DataValidation::STYLE_INFORMATION);
                        $cellValidation->setAllowBlank(false);
                        $cellValidation->setShowInputMessage(true);
                        $cellValidation->setShowErrorMessage(true);
                        $cellValidation->setShowDropDown(true);
                        $cellValidation->setErrorTitle("Input error.");
                        $cellValidation->setError('Value is not in this list.');
                        $cellValidation->setPromptTitle('Chose from list');
                        $cellValidation->setPrompt('Please, chose a value for dropdown list.');
        
                        $cellValidation->setFormula1('=branches_list');

                        $sheet->setCellValue('AB'. $i, "Select Division");
                        $cellValidation = $sheet->getCell('AB'.$i)->getDataValidation();
                        
                        $cellValidation->setType(DataValidation::TYPE_LIST);
                        $cellValidation->setErrorStyle(DataValidation::STYLE_INFORMATION);
                        $cellValidation->setAllowBlank(false);
                        $cellValidation->setShowInputMessage(true);
                        $cellValidation->setShowErrorMessage(true);
                        $cellValidation->setShowDropDown(true);
                        $cellValidation->setErrorTitle("Input error.");
                        $cellValidation->setError('Value is not in this list.');
                        $cellValidation->setPromptTitle('Chose from list');
                        $cellValidation->setPrompt('Please, chose a value for dropdown list.');
        
                        $cellValidation->setFormula1('=divisions_list');

                        $sheet->setCellValue('AC'. $i, "Select Department");
                        $cellValidation = $sheet->getCell('AC'.$i)->getDataValidation();
                        
                        $cellValidation->setType(DataValidation::TYPE_LIST);
                        $cellValidation->setErrorStyle(DataValidation::STYLE_INFORMATION);
                        $cellValidation->setAllowBlank(false);
                        $cellValidation->setShowInputMessage(true);
                        $cellValidation->setShowErrorMessage(true);
                        $cellValidation->setShowDropDown(true);
                        $cellValidation->setErrorTitle("Input error.");
                        $cellValidation->setError('Value is not in this list.');
                        $cellValidation->setPromptTitle('Chose from list');
                        $cellValidation->setPrompt('Please, chose a value for dropdown list.');
        
                        $cellValidation->setFormula1('=departments_list');

                        $sheet->setCellValue('A'. $i, $this->employees[$i - 3]['value']['employee_type']);
                        $sheet->setCellValue('B'. $i, $this->employees[$i - 3]['value']['position']);
                        $sheet->setCellValue('C'. $i, $this->employees[$i - 3]['value']['item_code']);
                        $sheet->setCellValue('D'. $i, $this->employees[$i - 3]['value']['employee_no']);
                        $sheet->setCellValue('E'. $i, $this->employees[$i - 3]['value']['first_name']);
                        $sheet->setCellValue('F'. $i, $this->employees[$i - 3]['value']['middle_name']);
                        $sheet->setCellValue('G'. $i, $this->employees[$i - 3]['value']['last_name']);
                        $sheet->setCellValue('H'. $i, $this->employees[$i - 3]['value']['suffix']);
                        $sheet->setCellValue('I'. $i, $this->employees[$i - 3]['value']['e_mail']);
                        $sheet->setCellValue('J'. $i, $this->employees[$i - 3]['value']['gender']);
                        $sheet->setCellValue('K'. $i, $this->employees[$i - 3]['value']['citizenship']);
                        $sheet->setCellValue('L'. $i, $this->employees[$i - 3]['value']['citizenship_if_holder_of_dual_citizenship_please_indicate_the_details']);
                        $sheet->setCellValue('M'. $i, $this->employees[$i - 3]['value']['civil_status']);
                        $sheet->setCellValue('N'. $i, $this->employees[$i - 3]['value']['civil_status_if_others_please_specify']);
                        $sheet->setCellValue('O'. $i, $this->employees[$i - 3]['value']['telephone_number']);
                        $sheet->setCellValue('P'. $i, $this->employees[$i - 3]['value']['contact_number']);
                        $sheet->setCellValue('Q'. $i, $this->employees[$i - 3]['value']['date_of_birth_mmddyyyy']);
                        $sheet->setCellValue('R'. $i, $this->employees[$i - 3]['value']['place_of_birth']);
                        $sheet->setCellValue('S'. $i, $this->employees[$i - 3]['value']['houseblocklot_no']);
                        $sheet->setCellValue('T'. $i, $this->employees[$i - 3]['value']['street']);
                        $sheet->setCellValue('U'. $i, $this->employees[$i - 3]['value']['subdivisionvillage']);
                        $sheet->setCellValue('V'. $i, $this->employees[$i - 3]['value']['barangay']);
                        $sheet->setCellValue('W'. $i, $this->employees[$i - 3]['value']['citymunicipality']);
                        $sheet->setCellValue('X'. $i, $this->employees[$i - 3]['value']['province']);
                        $sheet->setCellValue('Y'. $i, $this->employees[$i - 3]['value']['zip_code']);
                        $sheet->setCellValue('Z'. $i, $this->employees[$i - 3]['value']['corporation']);
                        $sheet->setCellValue('AA'. $i, $this->employees[$i - 3]['value']['branch']);
                        $sheet->setCellValue('AB'. $i, $this->employees[$i - 3]['value']['division']);
                        $sheet->setCellValue('AC'. $i, $this->employees[$i - 3]['value']['department']);
                    }
                    
                }else {
                    $sheet = $event->sheet;

                    $gender = "Male,Female";
                    $citizenship = "Filipino,By_Birth,Dual_Citizenship,By_Naturalization";
                    $civil_status = "Single,Married,Widowed,Separated,Other/s";
                    $country ="Afghanistan,Albania,Algeria,Andorra,Angola,Antigua and Barbuda,Argentina,Armenia,Australia,Austria,Azerbaijan,The Bahamas,Bahrain,Bangladesh,Barbados,Belarus,Belgium,Belize,Benin,Bhutan,Bolivia,Bosnia and Herzegovina,Botswana,Brazil,Brunei,Bulgaria,Burkina Faso,Burundi,Cabo Verde,Cambodia,Cameroon,Canada,Central African Republic,Chad,Chile,China,Colombia,Comoros,Congo,Democratic Republic of the,Congo,Republic of the,Costa Rica,Côte d’Ivoire,Croatia,Cuba,Cyprus,Czech Republic,Denmark,Djibouti,Dominica,Dominican Republic,East Timor (Timor-Leste),Ecuador,Egypt,El Salvador,Equatorial Guinea,Eritrea,Estonia,Eswatini,Ethiopia,Fiji,Finland,France,Gabon,The Gambia,Georgia,Germany,Ghana,Greece,Grenada,Guatemala,Guinea,Guinea-Bissau,Guyana,Haiti,Honduras,Hungary,Iceland,India,Indonesia,Iran,Iraq,Ireland,Israel,Italy,Jamaica,Japan,Jordan,Kazakhstan,Kenya,Kiribati,Korea,North,Korea,South,Kosovo,Kuwait,Kyrgyzstan,Laos,Latvia,Lebanon,Lesotho,Liberia,Libya,Liechtenstein,Lithuania,Luxembourg,Madagascar,Malawi,Malaysia,Maldives,Mali,Malta,Marshall Islands,Mauritania,Mauritius,Mexico,Micronesia,Federated States of,Moldova,Monaco,Mongolia,Montenegro,Morocco,Mozambique,Myanmar (Burma),Namibia,Nauru,Nepal,Netherlands,New Zealand,Nicaragua,Niger,Nigeria,North Macedonia,Norway,Oman,Pakistan,Palau,Panama,Papua New Guinea,Paraguay,Peru,Philippines,Poland,Portugal,Qatar,Romania,Russia,Rwanda,Saint Kitts and Nevis,Saint Lucia,Saint Vincent and the Grenadines,Samoa,San Marino,Sao Tome and Principe,Saudi Arabia,Senegal,Serbia,Seychelles,Sierra Leone,Singapore,Slovakia,Slovenia,Solomon Islands,Somalia,South Africa,Spain,Sri Lanka,Sudan,Sudan, South,Suriname,Sweden,Switzerland,Syria,Taiwan,Tajikistan,Tanzania,Thailand,Togo,Tonga,Trinidad and Tobago,Tunisia,Turkey,Turkmenistan,Tuvalu,Uganda,Ukraine,United Arab Emirates,United Kingdom,United States,Uruguay,Uzbekistan,Vanuatu,Vatican City,Venezuela,Vietnam,Yemen,Zambia,Zimbabwe";

                    // Gender
                    $genderArray = explode(",", $gender);
                    $genderCount = count($genderArray);

                    for ($i = 1; $i < $genderCount + 1; $i++) { 
                        $sheet->setCellValue('E' . $i , $genderArray[$i - 1]);
                    }

                    // set cell as a range value to use in combobox
                    $sheet->getParent()->addNamedRange(new NamedRange('genders_list', $sheet->getDelegate(), '$E$1:$E$'. strval($genderCount)));

                    // Citizenship
                    $citizenshipArray = explode(",", $citizenship);
                    $citizenshipCount = count($citizenshipArray);

                    for ($i = 1; $i < $citizenshipCount + 1; $i++) { 
                        $sheet->setCellValue('F' . $i , $citizenshipArray[$i - 1]);
                    }

                    // set cell as a range value to use in combobox
                    $sheet->getParent()->addNamedRange(new NamedRange('citizenship_list', $sheet->getDelegate(), '$F$1:$F$'. strval($citizenshipCount)));

                    // Country
                    $countryArray = explode(",", $country);
                    $countryCount = count($countryArray);

                    for ($i = 1; $i < $countryCount + 1; $i++) { 
                        $sheet->setCellValue('G' . $i , $countryArray[$i - 1]);
                    }

                    // set cell as a range value to use in combobox
                    $sheet->getParent()->addNamedRange(new NamedRange('dual_citizenship', $sheet->getDelegate(), '$G$1:$G$'. strval($countryCount)));

                    // Civil status
                   $civil_statusArray = explode(",",$civil_status);
                   $civil_statusCount = count($civil_statusArray);

                    for ($i = 1; $i <$civil_statusCount + 1; $i++) { 
                        $sheet->setCellValue('H' . $i ,$civil_statusArray[$i - 1]);
                    }

                    // set cell as a range value to use in combobox
                    $sheet->getParent()->addNamedRange(new NamedRange('civil_list', $sheet->getDelegate(), '$H$1:$H$'. strval($civil_statusCount)));
                    
                    // Corporation
                    $result = Corporation::select("name")->get();

                    for ($i = 1; $i < count($result) + 1; $i++) { 
                        $sheet->setCellValue('A' . $i ,$result[$i - 1]['name']);
                    }

                    // set cell as a range value to use in combobox
                    $sheet->getParent()->addNamedRange(new NamedRange('corporations_list', $sheet->getDelegate(), '$A$1:$A$'. strval(count($result))) );

                    // BRANCH
                    $result = Branch::select("name")->get();

                    for ($i = 1; $i < count($result) + 1; $i++) { 
                        $sheet->setCellValue('B' . $i , $result[$i - 1]['name']);
                    }

                    // set cell as a range value to use in combobox
                    $sheet->getParent()->addNamedRange(new NamedRange('branches_list', $sheet->getDelegate(), '$B$1:$B$'. strval(count($result))));

                    // Division
                    $result = Division::select("name")->get();

                    for ($i = 1; $i < count($result) + 1; $i++) { 
                        $sheet->setCellValue('C' . $i , $result[$i - 1]['name']);
                    }

                    // set cell as a range value to use in combobox
                    $sheet->getParent()->addNamedRange(new NamedRange('divisions_list', $sheet->getDelegate(), '$C$1:$C$'. strval(count($result))));

                    // Department

                    $result = Department::select("name")->get();

                    for ($i = 1; $i < count($result) + 1; $i++) { 
                        $sheet->setCellValue('D' . $i , $result[$i - 1]['name']);
                    }

                    // set cell as a range value to use in combobox
                    $sheet->getParent()->addNamedRange(new NamedRange('departments_list', $sheet->getDelegate(), '$D$1:$D$'. strval(count($result))));

                    // Employee Type

                    $result = EmployeeType::select("title")->get();

                    for ($i = 1; $i < count($result) + 1; $i++) { 
                        $sheet->setCellValue('I' . $i , $result[$i - 1]['title']);
                    }

                     // set cell as a range value to use in combobox
                     $sheet->getParent()->addNamedRange(new NamedRange('employee_type', $sheet->getDelegate(), '$I$1:$I$'. strval(count($result))));

                    //  Positions

                    $result = Position::select("title")->get();

                    for ($i = 1; $i < count($result) + 1; $i++) { 
                        $sheet->setCellValue('J' . $i , $result[$i - 1]['title']);
                    }

                     // set cell as a range value to use in combobox
                     $sheet->getParent()->addNamedRange(new NamedRange('positions', $sheet->getDelegate(), '$J$1:$J$'. strval(count($result))));

                    //  Item Code
                    $result = ItemCode::select("item_code")->get();

                    for ($i = 1; $i < count($result) + 1; $i++) { 
                        $sheet->setCellValue('K' . $i , $result[$i - 1]['item_code']);
                    }

                     // set cell as a range value to use in combobox
                     $sheet->getParent()->addNamedRange(new NamedRange('item_codes_list', $sheet->getDelegate(), '$J$1:$J$'. strval(count($result))));

                }
            }
        ];
        
    }
}
