<?php

namespace Suiterus\Adg\Exports\BCE;

use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\WithMultipleSheets;
use Suiterus\Adg\Exports\BCE\EmployeesExportSheet;

class EmployeesExport implements WithMultipleSheets
{
    use Exportable;
    /**
    * @return \Illuminate\Support\Collection
    */

    private $employees;

    public function __construct($rows){
        $this->employees = $rows;
    }

    /**
     * @return array
     */
    public function sheets(): array
    {
        $sheets = [];

        $sheets[] = new EmployeesExportSheet("BATCH_EMPLOYEE_TEMPLATE", $this->employees);
        $sheets[] = new EmployeesExportSheet("TEMPORARY_VALUE", null);
        
        return $sheets;
    }

    
}
