<?php

namespace Suiterus\Adg\Exports\Attendance;

use App\Models\User;
use Illuminate\Database\Eloquent\Collection;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithTitle;
use Maatwebsite\Excel\Concerns\WithStyles;
use Maatwebsite\Excel\Concerns\WithEvents;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Cell\DataValidation;
use Maatwebsite\Excel\Events\AfterSheet;
use PhpOffice\PhpSpreadsheet\NamedRange;
use PhpOffice\PhpSpreadsheet\Shared\Date;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

class AttendanceExportFailureSheet implements FromCollection, WithTitle, WithStyles, WithEvents
{
    private $title;
    private $failure;

    public function __construct($title, $failure)
    {
        $this->title = $title;
        $this->failure = $failure;
    }

    /**
     * @return Builder
     */
    public function collection()
    {
        return new Collection();
    }

    /**
     * @return string
     */
    public function title(): string
    {
        return $this->title;
    }

    public function styles(Worksheet $sheet){
        if ($this->title == "BATCH_ATTENDANCES_ERRORS") {
            $sheet->getStyle("A1:D1")->getFont()->setBold(true);

            $style = array(
                'alignment' => array(
                    'horizontal' => Alignment::HORIZONTAL_CENTER
                )
            );
        
            $sheet->getStyle("A1:D1")->applyFromArray($style);

            // Column Width
            $sheet->getColumnDimension("A")->setWidth(30.14);
            $sheet->getColumnDimension("B")->setWidth(22.43);
            $sheet->getColumnDimension("C")->setWidth(22.43);
            $sheet->getColumnDimension("D")->setWidth(40.14);
            $sheet->getRowDimension(1)->setRowHeight("30");

            // styling header
            $styleArray = array(
                'borders' => array(
                    'allBorders' => array(
                        'borderStyle' => Border::BORDER_THIN,
                        'color' => array('argb' => '00000000'),
                    ),
                ),
                'alignment' => [
                    'vertical' => Alignment::VERTICAL_CENTER,
                    'horizontal' => Alignment::HORIZONTAL_CENTER,
                    'wrapText' => true
                ],
                ''
            );

            for ($i = 1; $i < count($this->failure) + 2; $i++) { 
                $sheet->getStyle("A" . $i . ":D" . $i)->applyFromArray($styleArray);
            }

            // body
            $sheet->setCellValue("A1", "Employee / User");
            $sheet->setCellValue("B1", "Time In");
            $sheet->setCellValue("C1", "Time Out");
            $sheet->setCellValue("D1", "Remarks");
        }
    }

    public function registerEvents(): array{

        //$event = $this->getEvent();
     
        return [
            AfterSheet::class => function (AfterSheet $event) {
                if ($this->title == "BATCH_ATTENDANCES_ERRORS") {
                    /** @var Sheet $sheet */
                    $sheet = $event->sheet;
    
                    /**
                     * validation for bulkuploadsheet
                     */
    
                    $time_start = strtotime(date('Y-m-d') . ' 8:00 AM');
                    $time_end = strtotime(date('Y-m-d') . ' 5:00 PM');

                    $time_start_stamp = Date::PHPToExcel($time_start);
                    $time_end_stamp = Date::PHPToExcel($time_end);
                    
                    for ($i = 2; $i < count($this->failure) + 2; $i++) { 
                        $sheet->setCellValue('A'. $i, "Select Employee");
                        $cellValidation = $sheet->getCell('A'.$i)->getDataValidation();
                        
                        $cellValidation->setType(DataValidation::TYPE_LIST);
                        $cellValidation->setErrorStyle(DataValidation::STYLE_INFORMATION);
                        $cellValidation->setAllowBlank(false);
                        $cellValidation->setShowInputMessage(true);
                        $cellValidation->setShowErrorMessage(true);
                        $cellValidation->setShowDropDown(true);
                        $cellValidation->setErrorTitle("Input error.");
                        $cellValidation->setError('Value is not in this list.');
                        $cellValidation->setPromptTitle('Chose from list');
                        $cellValidation->setPrompt('Please, chose a value for dropdown list.');
        
                        $cellValidation->setFormula1('=employee');

                        $sheet->setCellValue('B' . $i, $time_start_stamp);
                        $sheet->getStyle('B'. $i)->getNumberFormat()
                            ->setFormatCode('yyyy-mm-dd h:mm AM/PM');
                        
                        $sheet->setCellValue('C' . $i, $time_end_stamp);
                        $sheet->getStyle('C'. $i)->getNumberFormat()
                            ->setFormatCode('yyyy-mm-dd h:mm AM/PM');
                        

                        $sheet->setCellValue('A'. $i, $this->failure[$i - 2]['value']['employee_user']);
                        $sheet->setCellValue('B'. $i, $this->failure[$i - 2]['value']['time_in']);
                        $sheet->setCellValue('C'. $i, $this->failure[$i - 2]['value']['time_out']);
                        $sheet->setCellValue('D'. $i, $this->failure[$i - 2]['value']['remarks']);
                        
                    }
                    
                }else {
                    $sheet = $event->sheet;

                    $result = User::whereHas('employeeMetaInfo')
                        ->whereHas('employeeSchedules')
                        ->with(['employeeMetaInfo' => function($query) {
                            $query->select('user_id','employee_id');
                        }])->without(['roles','permissions','storage'])->select('name', 'id')->get();

                    for ($i = 1; $i < count($result) + 1; $i++) { 
                        $res = $result[$i - 1];
                        $sheet->setCellValue('A' . $i , $res['employeeMetaInfo']['employee_id'] . ' - ' . $res['name']);
                    }

                    $sheet->getParent()->addNamedRange(new NamedRange('employee', $sheet->getDelegate(), '$A$1:$A$'. strval(count($result))));
                }
            }
        ];
        
    }
}
