<?php

namespace Suiterus\Adg\Exports\Attendance;

use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\WithMultipleSheets;
use Suiterus\Adg\Exports\Attendance\AttendanceExportSheet;

class AttendanceExport implements WithMultipleSheets
{
    use Exportable;
    /**
    * @return \Illuminate\Support\Collection
    */

    private $employees;

    public function __construct($rows){
        $this->employees = $rows;
    }

    /**
     * @return array
     */
    public function sheets(): array
    {
        $sheets = [];

        $sheets[] = new AttendanceExportSheet("ATTENDANCES_TEMPLATE", $this->employees);
        $sheets[] = new AttendanceExportSheet("TEMPORARY_VALUE", null);
        
        return $sheets;
    }

    
}
