<?php

namespace Suiterus\Adg\Exceptions\Reports;

use Exception;
use Throwable;

class ReportException extends Exception
{

    /**
     * This is a constructor function in PHP that initializes an object with a message, code, and
     * optional previous exception.
     * 
     * @param message The message parameter is a string that represents the error message associated
     * with the exception. It provides information about what went wrong and can be used to help debug
     * and troubleshoot issues.
     * @param code The code parameter is an optional parameter that allows you to specify an error code
     * for the exception. This can be useful for identifying specific types of errors or for handling
     * different exceptions in different ways. If not provided, the default value is 0.
     * @param Throwable previous The 3rd parameter is used to pass in an exception that was
     * previously thrown. This allows for chaining exceptions together, where one exception is the
     * cause of another exception. By passing in the previous exception, it provides additional context
     * and information about the error.
     */
    public function __construct($message, $code = 0, Throwable $previous = null)
    {
        parent::__construct($message, $code, $previous);
    }
}
