<?php

namespace Suiterus\Adg\Controllers\Timekeeping;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Support\Carbon;
use Exception;
use Illuminate\Database\Eloquent\ModelNotFoundException as ME;

class DTRController extends Controller
{
    
    public function search_attendance_date(Request $request)
    {
        $paginate = isset($request->paginate) && $request->paginate !== null ? $request->paginate : env('DEFAULT_PAGECOUNT');
        try {
            
            $year = $request->year;
            $data = [];

            for ($i = 1; $i < 13; $i++){
                if((Carbon::now()->year == $year && Carbon::now()->month < $i) || Carbon::now()->year < $year) continue;
                $data[] = [
                    'month' =>  $i,
                    'year'  => $year
                ];
                
            }
            $posts = [
                'data' => $data
            ];

            return response()->json([
                'data' => $posts
            ]);
        } catch (ME $me) {
            return response()->json([
                'errors'    => ['The selected filters could not be found.'],
                'message'   => $me->getMessage()
            ], 500);
        } catch (Exception $e) {
            return response()->json([
                'errors'    => ['There was a problem in fetching the records.'],
                'message'   => $e->getMessage(),
                'line'      => $e->getLine()
            ], 500);
        }
    }

    public function fetch_employees(Request $request) {
        
        $paginate = isset($request->paginate) && $request->paginate !== null ? $request->paginate : env('DEFAULT_PAGECOUNT');
        
        $employees = User::role(['Employee'])->with(['attendance' => function($query) use($request) {
            $query->whereMonth('time_in', $request->month)->whereYear('time_in', $request->year);
        }])->where('name', 'LIKE', '%'.$request->employeeName.'%')->whereHas('employeeMetaInfo', function($query) use ($request) {
            $query->when(isset($request->division), function($query) use ($request) {
                return $query->where('division_id', $request->division);
            })
            ->when(isset($request->department), function($query) use ($request) {
                return $query->where('department_id', $request->department);
            })
            ->when(isset($request->employee_id), function($query) use($request) {
                if(count($request->employee_id) > 0){
                    $query->whereIn('employee_id', $request->employee_id);
                } else{
                    $query->where('employee_id', $request->employee_id);
                }
            });
        })->paginate($paginate);

        return response()->json([
            'data' => $employees
        ]);
    }
}
