<?php

namespace Suiterus\Adg\Controllers\Salary\AllowanceAndPays;

use App\Enums\Status;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\User;
use Exception;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Suiterus\Adg\Models\Payroll\SpecialPay;
use Suiterus\Adg\Models\Salary\EmployeeSpecialPay;
use Suiterus\Adg\Models\Salary\UserSalary;
class EmployeeSpecialPayController extends Controller
{
    private $db;

    function __construct(){
        $this->db = DB::connection('adg_db');
    }

    /**
     * Fetch Special Pays
     */
    public function index(Request $request) {

        $validate = Validator::make($request->all(), [
            'user_id'   => 'required|exists:mysql.users,id',
        ]);

        if($validate->fails()) {
            return response()->json([
                'errors'    => $validate->errors()
            ], 400);
        }

        try {

            $user = User::find($request->user_id);

            $data = $user->special_pays()->where('status', Status::ACTIVE)->get();

            return response()->json([
                'data'    => $data 
            ]);

        } catch(Exception $e) {
            return response()->json([
                'errors'    => [__('responses.exception')],
                'message'   => $e->getMessage()
            ], 500);
        }

    }

    /**
     * Assign Special Pays
     */
    public function assign(Request $request) {

        $validate = Validator::make($request->all(), [
            'user_id'   => 'required|exists:mysql.users,id',
            'special_pays.*.id' => 'required|exists:adg_db.special_pays,id'
        ]);

        if($validate->fails()) {
            return response()->json([
                'errors'    => $validate->errors()
            ], 400);
        }

        $this->db->beginTransaction();
        try {

            $user = User::find($request->user_id);

            // This function sets an array with a key of the special pay's id
            // and the value as an associative array with a key 'amount'
            // and a value of the actual special pay amount for the specified special pay
            // Reference at https://laravel.com/docs/8.x/eloquent-relationships#syncing-associations

            $special_pays = [];
            foreach($request->special_pays as $special_pay) {
                $special_pays[$special_pay['id']] = ['amount' => $special_pay['amount']];
            }

            $user->special_pays()->sync($special_pays);

            $this->db->commit();
            return response()->json([
                'text'  => 'Special Pays assigned'
            ]);

        } catch(Exception $e) {
            $this->db->rollBack();
            return response()->json([
                'errors'    => [__('responses.exception')],
                'message'   => $e->getMessage()
            ], 500);
        }

    }

    public function syncSpecialPay() {
        
        $users =  User::whereHas('salary')->with('salary')->get();
        
        $this->db->beginTransaction();
        try {
            foreach($users as $user) {
                
                if ( $user->salary->official_business_pay > 0 ) {
                    $special_pay = SpecialPay::where('title', 'Official Business Pay')->first();
                    EmployeeSpecialPay::firstOrCreate([
                        'user_id'  =>  $user->id,
                        'special_pay_id' => $special_pay->id,
                        'amount' => $user->salary->official_business_pay,
                        'created_by' => $user->id,
                    ]);
                };

                if ( $user->salary->special_pay > 0 ) {
                    $special_pay = SpecialPay::where('title', 'Special Pay')->first();
                    EmployeeSpecialPay::firstOrCreate([
                        'user_id'  =>  $user->id,
                        'special_pay_id' => $special_pay->id,
                        'amount' => $user->salary->special_pay,
                        'created_by' => $user->id,
                    ]);
                };
                
            }

            $this->db->commit();
            return response()->json([
                'text'  => 'Old Special Pays successfully synced'
            ]);

        } catch(Exception $e) {
            $this->db->rollBack();
            return response()->json([
                'errors'    => [__('responses.exception')],
                'message'   => $e->getMessage()
            ], 500);
        }
    }
}
