<?php

namespace Suiterus\Adg\Controllers\SPMS;

use Exception;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;
use NcJoes\OfficeConverter\OfficeConverter;
use Suiterus\Adg\Models\SPMS\EmployeeEvaluation;
use Suiterus\Adg\Models\SPMS\Mfo;
use Suiterus\Adg\Models\SPMS\PCRFormType;
use Suiterus\Adg\Services\OrgStructure\OrgStructureService;

class PCRFormController extends Controller
{
    public function downloadPCRTemplate(Request $request){

        $employee_evaluation = EmployeeEvaluation::whereId($request->evaluation_id)->first();

        // Determine PCR type
        $reviewFormType = $employee_evaluation->review_form_type;

        $evaluationFormOrganization = $employee_evaluation->unit;
        $evaluationFormOrganization = $evaluationFormOrganization ?? $employee_evaluation->section;
        $evaluationFormOrganization = $evaluationFormOrganization ?? $employee_evaluation->division;
        $evaluationFormOrganization = $evaluationFormOrganization ?? $employee_evaluation->department;
        $evaluationFormOrganization = $evaluationFormOrganization ?? $employee_evaluation->office;

        if (!$evaluationFormOrganization) {
            throw new Exception('Employee organization not found');
        }

        $strategic = Mfo::where('name', 'Strategic')->first();

        $hasStrategic = EmployeeEvaluation::whereId($request->evaluation_id)->whereHas('performanceEvaluations', function ($query) use ($strategic) {
            $query->where('mfo', $strategic->id);
        })->first();

        if ($hasStrategic) {
            $fileName = '3 Rev2024 DeDPCR DePCR DiPCR SPCR UPCR.docx';
        }

        $pcrFormType = PCRFormType::where('id', $reviewFormType)->first();

        if (strtolower($pcrFormType->abbreviation) == 'ipcr' && !$hasStrategic) {
            $fileName = '1 Rev2024 IPCR.docx';
        }

        if (in_array(strtolower($pcrFormType->abbreviation), ['dipcr', 'spcr', 'upcr']) && !$hasStrategic) {
            $fileName = '2 Rev2024 DiPCR SPCR UPCR.docx';
        }

        return response()->download(public_path($fileName));
    }

    public function convertPCRToPdf(Request $request){

        $path = Str::uuid();

        $request->file('file')->storeAs($path, 'PCR.docx', 'converted_office');

        $converter = new OfficeConverter(Storage::disk('converted_office')->path("{$path}/PCR.docx"), null, env('LIBRE_OFFICE_COMMAND'), false);
        $converter->convertTo('PCR.pdf');

        Storage::disk('converted_office')->delete("{$path}/PCR.docx");

        return response()->download(Storage::disk('converted_office')->path("{$path}/PCR.pdf"))->deleteFileAfterSend();
    }
}
