<?php

namespace Suiterus\Adg\Controllers\SPMS;


use App\Models\User;
use Illuminate\Http\Request;
use Suiterus\Adg\Models\SM\Unit;
use Suiterus\Adg\Models\SM\Office;
use Suiterus\Adg\Models\SM\Section;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Suiterus\Adg\Models\SM\Division;
use Suiterus\Adg\Models\SM\Department;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;
use Suiterus\Adg\Models\SPMS\PerformanceRatingReport;
use Suiterus\Adg\Services\OrgStructure\OrgStructureService;

class AdminEvaluationController extends Controller
{
    private $orgStructureService;

    public function __construct(OrgStructureService $orgStructureService)
    {
        $this->orgStructureService = $orgStructureService;
    }

    public function getEvaluationScore(Request $request)
    {
        $classes = [
            'office' => new Office(),
            'department' => new Department(),
            'division' => new Division(),
            'section' => new Section(),
            'unit' => new Unit()
        ];

        $getObject = $classes[$request->type];

        $object = $getObject::when($request->id, function ($query) use ($request) {
            return $query->where('id', $request->id);
        })->when($request->name, function ($query) use ($request) {
            return $query->where('name', urldecode($request->name));
        })->when($getObject instanceof Office, function ($query) {
            $query->without(['childOffices', 'childOffices.childOffice.department.division.section.unit']);
        })->first();

        if ($getObject instanceof Office) {
            $object->childOffices = $this->orgStructureService->evaluationScoreMapper($object->childOffices->map(function ($office) {
                return $office->childOffice;
            }), $request->start_date, $request->end_date);

            $object->department = $this->orgStructureService->evaluationScoreMapper($object->department, $request->start_date, $request->end_date);

            $object->divisions = $this->orgStructureService->evaluationScoreMapper($object->divisions, $request->start_date, $request->end_date);

            $object->units = $this->orgStructureService->evaluationScoreMapper($object->units, $request->start_date, $request->end_date);

        } else if ($getObject instanceof Department) {
            $object->divisions = $this->orgStructureService->evaluationScoreMapper($object->divisions, $request->start_date, $request->end_date);

            $object->units = $this->orgStructureService->evaluationScoreMapper($object->units, $request->start_date, $request->end_date);
        } else if ($getObject instanceof Division) {
            $object->sections = $this->orgStructureService->evaluationScoreMapper($object->sections, $request->start_date, $request->end_date);

            $object->units = $this->orgStructureService->evaluationScoreMapper($object->units, $request->start_date, $request->end_date);
        } else if ($getObject instanceof Section) {
            $object->units = $this->orgStructureService->evaluationScoreMapper($object->units, $request->start_date, $request->end_date);
        }

        return $object;
    }
}
