<?php

namespace Suiterus\Adg\Controllers\SM;

use App\Enums\Log\RosterSetupLogType;
use App\Http\Controllers\Controller;
use App\Traits\Logs\HasCustomLogs;
use Exception;
use Illuminate\Database\Eloquent\ModelNotFoundException as ME;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Suiterus\Adg\Models\Activity\Activity;
use Suiterus\Adg\Models\Timekeeping\Roster\RosterLegend;

class RosterLegendController extends Controller
{
    use HasCustomLogs;
    public function create_legend(Request $request) {

        $valid = Validator::make($request->all(),[
            'name'    =>  'required|string|unique:adg_db.roster_legends,name,NULL,id,deleted_at,NULL',
            'description'   =>  'string|nullable',
            'color'     =>  'string',
            'status' => 'integer|required'
        ],[
            'name.unique'   =>  $request->name.' is already taken.',
        ]);
        if($valid->fails()){
            return response()->json([
                'errors'    =>  $valid->errors()
            ],400);
        }
        DB::beginTransaction();
        try {
            
            $data = RosterLegend::create([
                'key'   =>  $request->key,
                'name'  =>   $request->name,
                'description'   =>  $request->description,
                'color' =>  $request->color,
                'status'    => $request->status ? $request->status : 1
            ]);

            $this->logCustomMessage(
                'create_roster_legend',
                $data,
                Auth::user()->name . ' Create roster legend',
                $data,
                RosterSetupLogType::CREATE,
                new Activity()
            );

            DB::commit();
            return response()->json([
                'text'  =>  $request->name.' created successfully.'
            ]);
        } catch (Exception $e) {
            DB::rollback();
            return response()->json([
                'errors'    =>  [ 'Can`t create your entry as of now. Contact the developer to fix it. Error Code : SM-comp-0x01' ],
                'msg'   =>  $e->getMessage()
            ],500);
        }
    }

    public function init_list_legend(){
        return response()->json([
            'data'  =>  RosterLegend::orderBy('id', 'desc')->paginate(5)
        ]);
    }

    public function search_legend_name(Request $request){
        return response()->json([
            'data'  =>  RosterLegend::where('name', 'LIKE', '%'.$request->keyword.'%')->paginate(5)
        ]);
    }

    public function update_legend(Request $request){
        $valid = Validator::make($request->all(),[
            'name'      =>  'required|string|unique:adg_db.roster_legends,name,'.$request->id.',id,deleted_at,NULL',
            'status'    => 'integer|required'
        ]);
        if($valid->fails()){
            return response()->json([
                'errors'    =>  $valid->errors()
            ],400);
        }
        DB::beginTransaction();
        try{
            try{
                $legend = RosterLegend::findOrFail($request->id);
                $old_record = $legend;
                $legend->update([
                    'key'   =>  $request->key,
                    'name'  =>   $request->name,
                    'description'   =>  $request->description,
                    'color' =>  $request->color,
                    'status'    => $request->status
                ]);
                
                $legend->save();

                $this->logCustomMessage(
                    'update_roster_legend',
                    $old_record,
                    Auth::user()->name . ' Update roster legend',
                    $legend,
                    RosterSetupLogType::UPDATE,
                    new Activity()
                );

                DB::commit();
                return response()->json([
                    'text'  =>  $request->name.' has been updated.'
                ]);
            }catch(ME $ee){
                DB::rollback();
                return response()->json([
                    'errors'    =>  [ 'Roster Legend doesn`t exists.' ],
                ],400);
            }
        }catch(Exception $e){
            DB::rollback();
            return response()->json([
                'errors'    =>  [ 'There is a problem in updating a Roster Legend.' ],
                'msg'       =>  $e->getMessage()
            ],500);
        }
    }

    public function delete_legend(Request $request){
        DB::beginTransaction();
        try{
            $perm = RosterLegend::findOrFail($request->id);
            $perm->delete();

            $this->logCustomMessage(
                'delete_roster_legend',
                $perm,
                Auth::user()->name . ' Delete roster legend',
                $perm,
                RosterSetupLogType::DELETE,
                new Activity()
            );

            DB::commit();
            return response()->json([
                'text'  =>  'Roster Legend has been deleted.'
            ]);
        }catch(ME $ee){
            DB::rollback();
            return response()->json([
                'errors'    =>  [ 'Roster Legend doesnt exists.' ],
            ],400);
        }
    }
}
