<?php

namespace Suiterus\Adg\Controllers\SM;

use Validator;
use Exception;
use Illuminate\Http\Request;
use Suiterus\Adg\Models\SM\Remark;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class RemarkController extends Controller
{

    public function index(){
        return Remark::orderBy('id', 'desc')->get();
    }

    public function create_remark(Request $request){

        $valid = Validator::make($request->all(),[
            'abbreviation'    =>  'required|string|unique:adg_db.remarks',
            'meaning'         =>  'required|string|unique:adg_db.remarks'
        ],
        [
            'meaning.unique'   =>  $request->meaning.' is already taken.',
        ]);
        if($valid->fails()){
            return response()->json([
                'errors'    =>  $valid->errors()
            ],400);
        }
        DB::beginTransaction();
        try {
            $remark = Remark::create([
                'abbreviation' => $request->abbreviation,
                'meaning'      => $request->meaning
            ]);
            DB::commit();
            return response()->json([
                'text'  =>  $request->abbreviation.' - '.$request->meaning.' created successfully.'
            ]);
        } catch (Exception $e) {
            DB::rollback();
            return response()->json([
                'errors'    =>  [ 'Can`t create your entry as of now. Contact the developer to fix it. Error Code : SM-comp-0x01' ],
                'msg'       =>  $e->getMessage(),
                'line'      => $e->getLine
            ],500);
        }
    }

    public function init_list_remark(){
        return response()->json([
            'data'  =>  Remark::orderBy('id', 'desc')->paginate(5)
        ]);
    }

    public function search_remark(Request $request){
        return response()->json([
            'data'  =>  Remark::where('meaning', 'LIKE', '%'.$request->keyword.'%')->paginate(5)
        ]);
    }

    public function edit_remark(Request $request){
        $valid = Validator::make($request->all(),[
            'abbreviation'      =>  'required|string',
            'meaning'           =>  'required|string'
        ]);
        if($valid->fails()){
            return response()->json([
                'errors'    =>  $valid->errors()
            ],400);
        }
        DB::beginTransaction();
        try{
            try{
                Remark::findOrFail($request->id)->update([
                    'abbreviation'  =>  $request->abbreviation,
                    'meaning'       =>  $request->meaning,
                    'status'        =>  $request->status
                ]);

                DB::commit();
                return response()->json([
                    'text'  =>  $request->abbreviation.' - '.$request->meaning.' has been updated.'
                ]);
            }catch(ME $ee){
                DB::rollback();
                return response()->json([
                    'errors'    =>  [ 'Remark doesnt exists.' ],
                ],400);
            }
        }catch(Exception $e){
            DB::rollback();
            return response()->json([
                'errors'    =>  [ 'There is a problem in updating a Remark.' ],
                'msg'       =>  $e->getMessage()
            ],500);
        }
    }

    public function delete_remark(Request $request){
        DB::beginTransaction();
        try{
            $perm = Remark::findOrFail($request->id)->delete();
            DB::commit();
            return response()->json([
                'text'  =>  'Remark has been deleted.'
            ]);
        }catch(ME $ee){
            DB::rollback();
            return response()->json([
                'errors'    =>  [ 'Remark doesnt exists.' ],
            ],400);
        }
    }
}
