<?php

namespace Suiterus\Adg\Controllers\SM;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Suiterus\Adg\Models\SM\Division_history;

class DivisionHistoryController extends Controller
{
    // ** fetch all 
    public function fetch_division_history(Request $req){

        $paginate = $req->paginate ? intval($req->paginate) : env('DEFAULT_PAGECOUNT');

        $records = Division_history::with(['user' => function($query){

            $query->select('id', 'name')->without('permissions', 'roles', 'storage', 'supervisor','employeeMetaInfo');

        }])->whereHas('user')->whereHas('division')->where('user_id', $req->user_id)->orderBy('created_at', 'desc')->paginate($paginate);

        return response()->json([
            'message'   =>  "Fetch successfully",
            'data'   =>  $records
        ]);

    }
}
