<?php

namespace Suiterus\Adg\Controllers\SM;

use Exception;
use Carbon\Carbon;
use App\Models\User;
use Illuminate\Http\Request;
use App\Traits\Logs\HasCustomLogs;
use Illuminate\Support\Facades\DB;
use Suiterus\Adg\Models\SM\Branch;
use Suiterus\Adg\Models\SM\Remark;
use Suiterus\Adg\Models\SM\Sector;
use App\Enums\Log\UserSalaryLogType;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Suiterus\Adg\Models\SM\Division;
use Suiterus\Adg\Models\SM\Department;
use Suiterus\Adg\Models\SM\Corporation;
use Suiterus\Adg\Models\SM\SalaryGrade;
use Illuminate\Support\Facades\Validator;
use Suiterus\Adg\Models\Activity\Activity;
use Suiterus\Adg\Models\Salary\UserSalary;
use Suiterus\Adg\Models\EMI\EmployeeMetaInfo;
use Suiterus\Adg\Models\Salary\PrivateSalary;
use Suiterus\Adg\Models\SM\DesignationHistory;
use Suiterus\Adg\Models\Salary\EmployeeAllowance;
use Suiterus\Adg\Models\ServiceRecord\ServiceRecord;


class DesignationHistoryController extends Controller
{
    use HasCustomLogs;
    
    // ** fetch all 
    public function fetch_designation_history(Request $req){

        $paginate = $req->paginate ? intval($req->paginate) : env('DEFAULT_PAGECOUNT');

        $records = DesignationHistory::where('user_id', $req->user_id)->with('corporation', 'branch', 'division', 'department')
		->orderBy('date_of_designation', 'desc')->paginate($paginate);

        return response()->json([
            'message'   =>  "Fetch successfully",
            'data'      =>  $records
        ]);

    }

    // ** Update for Company Details --
    public function update_company_details(Request $req){
        $valid = Validator::make($req->all(), [
            'user_id'                =>  'integer|required',
            'corp_id'                =>  'integer|nullable|',
            'branch_id'              =>  'integer|nullable|',
            'division_id'            =>  'integer|required',
            'department_id'          =>  'integer|required',
            'date_of_designation'    =>  'required'
        ]);

        if($valid->fails()) {
            return response()->json([
                'errors'    => $valid->errors()
            ], 400);
        }
        
        try{
            $activeSector = Sector::where('status', 'active')->first();
            $sector = $activeSector->name;

            $updateRecord = EmployeeMetaInfo::where('user_id', $req->user_id)->first();
            
            $status = 1; // for 'current'
            $record = DesignationHistory::where('user_id',$req->user_id)->orderBy('id', 'desc')->first();
        
            $totalAllowance = 0;
                
            $allowance = EmployeeAllowance::where('user_id', $req->user_id)->get();

            
            foreach($allowance as $allowances) {
                $totalAllowance += $allowances['amount'];
            }

            if($allowance === null){
                $allAllowances = 0;
            }
            else{
                $allAllowances = $totalAllowance;
            }

            if($sector == 'public')
            {
                $updateRecord->update([
                    'corp_id'       => null,
                    'branch_id'     => null,
                    'division_id'   => $req->division_id,
                    'department_id' => $req->department_id,
                    'modified_by'   => Auth::id()
                ]);

                if(isset($record->date_of_designation) && $record->date_of_designation != null){
                    $date1 = Carbon::createFromFormat('Y-m-d', strval($req->date_of_designation)); 
                    $date2 = Carbon::createFromFormat('Y-m-d', strval($record->date_of_designation)); 
    
                    if($date1->gt($date2)){
                        $status = 2; // for 'previous'
                        DesignationHistory::where('user_id', $req->user_id)->orderBy('id', 'desc')->first()
                        ->update([
                            'status'        =>  $status,
                            'updated_by'    =>  Auth::id()
                        ]);
                    }
                }

                DesignationHistory::with(['user' => function($query){
                    $query->select('id', 'name')->without('permissions', 'roles', 'storage', 'employeeMetaInfo');
                }, 'user.user_employeeMetaInfo' => function($query) use($req){
                    $query->select('id', 'user_id')->without(['storage','roles','permissions','department','branch','division','position','employeeMetaInfo']);
                        $query->where('user_id', $req->user_id);
                }])->create([
                    'user_id'             =>    $req->user_id,
                    'corp_id'             =>    null,
                    'branch_id'           =>    null,
                    'division_id'         =>    $req->division_id,
                    'department_id'       =>    $req->department_id,
                    'date_of_designation' =>    $req->date_of_designation,
                    'status'              =>    $req->status ? $req->status: 1,
                    'created_by'          =>    Auth::id()
                ]);
    
                $companyDetails = array([
                    'division'    =>    Division::where('id', $req->division_id)->first(),
                    'department'  =>    Department::where('id', $req->department_id)->first(),                
                ]);

                $newSalary = SalaryGrade::whereHas('publicSalary', function($query) use($req){
                    $query->whereHas('userSalary', function($query) use($req){
                        $query->where([
                            ['user_id', $req->user_id]
                        ]);
                    });
                })->first();

                $salary = $newSalary->value;
                $salary = str_replace( ',', '', $salary);
                $annualSalary = $salary * 12;

                $oldServiceRecord = ServiceRecord::where('user_id', $req->user_id)->whereNull('end_date');
                    $endDate = date('Y-m-d', strtotime(now()));
                    $oldServiceRecord->update([
                        'end_date'  => $endDate
                    ]);


                $remark = Remark::whereId(6)->first();

               ServiceRecord::create([
                    'user_id'           =>  $req->user_id,
                    'start_date'        =>  $req->date_of_designation, 
                    'position_id'       =>  $updateRecord->position_id,
                    'salary'            =>  $annualSalary,
                    'allowance'         =>  $allAllowances,
                    'employee_type_id'  =>  $updateRecord->employee_type,
                    'division_id'       =>  $req->division_id,
                    'remark_id'         =>  $remark->id,  //* Transferred - department
                    'created_by'        =>  Auth::id(),
                ]);

            }else{

                $updateRecord->update([
                    'corp_id'       => $req->corp_id,
                    'branch_id'     => $req->branch_id,
                    'division_id'   => $req->division_id,
                    'department_id' => $req->department_id,
                    'modified_by'   => Auth::id()
                ]);

                if(isset($record->date_of_designation) && $record->date_of_designation != null){
                    $date1 = Carbon::createFromFormat('Y-m-d', strval($req->date_of_designation)); 
                    $date2 = Carbon::createFromFormat('Y-m-d', strval($record->date_of_designation)); 
    
                    if($date1->gt($date2)){
                        $status = 2; // for 'previous'
                        DesignationHistory::where('user_id', $req->user_id)->orderBy('id', 'desc')->first()
                        ->update([
                            'status'        =>  $status,
                            'updated_by'    =>  Auth::id()
                        ]);
                    }
                }

                DesignationHistory::with(['user' => function($query){
                    $query->select('id', 'name')->without('permissions', 'roles', 'storage', 'employeeMetaInfo');
                }, 'user.user_employeeMetaInfo' => function($query) use($req){
                    $query->select('id', 'user_id')->without(['storage','roles','permissions','department','branch','division','position','employeeMetaInfo']);
                        $query->where('user_id', $req->user_id);
                }])->create([
                    'user_id'             =>    $req->user_id,
                    'corp_id'             =>    $updateRecord->corp_id ? $updateRecord->corp_id : 0,
                    'branch_id'           =>    $updateRecord->branch_id ? $updateRecord->branch_id : 0,
                    'division_id'         =>    $req->division_id,
                    'department_id'       =>    $req->department_id,
                    'date_of_designation' =>    $req->date_of_designation,
                    'status'              =>    $req->status ? $req->status : 1,
                    'created_by'          =>    Auth::id()
                ]);


                if($record->department_id != $req->department_id){

                    $newSalary = PrivateSalary::whereHas('userSalary', function ($query) use($req){
                        $query->where('user_id', $req->user_id);
                    })->first();
                
                    if($newSalary){
                        $salary = $newSalary->salary;
                        $annualSalary = $salary * 12;
                    }

                    $oldServiceRecord = ServiceRecord::where('user_id', $req->user_id)->whereNull('end_date');
                        $endDate = date('Y-m-d', strtotime(now()));
                        $oldServiceRecord->update([
                            'end_date'  => $endDate
                        ]);

                    $remark = Remark::whereId(6)->first();
                    ServiceRecord::create([
                    'user_id'           =>  $req->user_id,
                    'start_date'        =>  $req->date_of_designation, 
                    'position_id'       =>  $updateRecord->position_id,
                    'salary'            =>  $annualSalary,
                    'allowance'         =>  $allAllowances,
                    'employee_type_id'  =>  $updateRecord->employee_type,
                    'division_id'       =>  $req->division_id,
                    'remark_id'         =>  $remark->id,  //* Transferred - department
                    'created_by'        =>  Auth::id(),
                    ]);
                    
                }

                $companyDetails = array([
                    'branch'      =>    Branch::where('id', $req->branch_id)->first(),
                    'corporation' =>    Corporation::where('id', $req->corp_id)->first(),
                    'division'    =>    Division::where('id', $req->division_id)->first(),
                    'department'  =>    Department::where('id', $req->department_id)->first(),                
                ]);
            }

            $newRecord = DesignationHistory::where('user_id',$req->user_id)->orderBy('id', 'desc')->first();

            $newRecord->old = collect($record);
            $newRecord->attributes = collect($newRecord);
                    
            $this->logCustomMessage(
                'update_company_details',
                $newRecord,
                Auth::user()->name . ' updated the company details of ' . $newRecord->user->name,
                $newRecord,
                UserSalaryLogType::UPDATE_COMPANY_DETAILS,
                new Activity()
            );

            DB::commit();
            return response()->json([
                'text'  => 'Company Details updated successfully.',
                'data'  =>  $companyDetails
            ]);

        }catch(Exception $e){

		    DB::rollback();
            return response()->json([
                'errors'    =>  [ 'Can`t create your entry as of now. Contact the developer to fix it. Error Code : SM-comp-0x01' ],
                'msg'       =>  $e->getMessage(),
                'line'      =>  $e->getLine()
            ],500);

        }
    }

    //FETCH EMPLOYEE
    public function fetch_employees(){

        $employee = User::whereHas('employeeMetaInfo')->without([
            'currentRole',
            'roles',
            'permissions',
            'storage',
            'supervisor',
            'user_supervisor',
            'exitInterview',
            'userProfilePicture',
            'profileBasicInfo'
        ])->with(['employeeMetaInfo' => function($query){
            $query->without('employeeType','position','corporation','branch','division','department');
        }])->get();
        
        return response()->json([
            'text' => 'fetch successful.',
            'data' => $employee
        ]);

    }

    public function init_list_all_corporation(){
        return Corporation::all();
    }

    public function init_list_all_branch(){
        return Branch::all();
    }

    public function init_list_all_division(){
        return Division::all();
    }

    public function init_list_all_department(){
        return Department::all();
    }
}
