<?php

namespace Suiterus\Adg\Controllers\SM;

use App\Enums\Log\ScheduleSetupLogType;
use App\Traits\Logs\HasCustomLogs;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;
use Suiterus\Adg\Models\SM\ScheduleTitle;
use Suiterus\Adg\Models\SM\ScheduleTemplate;

use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Support\Facades\Auth;
use Suiterus\Adg\Models\Activity\Activity;

class DefaultScheduleController extends Controller
{
    use HasCustomLogs;
    public function set_active_schedule(Request $request) {
        $validate = Validator::make($request->all(), [
            'id'    => 'required|numeric'
        ]);

        if($validate->fails()) {
            return response()->json([
                'errors'    => $validate->errors()
            ], 400);
        }

        DB::beginTransaction();
        try {

            $current_schedule = ScheduleTitle::where('active_schedule', 1)->first();
            $selected_schedule = ScheduleTitle::findOrFail($request->id);
            $selected_schedule->active_schedule = 1;

            if($current_schedule !== null) {
                $current_schedule->active_schedule = 0;
                $current_schedule->save();
            }
            $selected_schedule->save();

            $this->logCustomMessage(
                'set_active_schedule',
                $selected_schedule,
                Auth::user()->name . ' Set active default schedule',
                $selected_schedule,
                ScheduleSetupLogType::ACTIVE,
                new Activity()
            );
            DB::commit();

            return response()->json([
                'text'  => $selected_schedule->title . ' has been set as the active schedule'
            ]);
            
        } catch(ModelNotFoundException $e) {
            DB::rollBack();
            return response()->json([
                'errors'    => ['The selected schedule could not be found.'],
                'message'   => $e->getMessage()
            ], 500);    
        } catch(Exception $e) {
            DB::rollBack();
            return response()->json([
                'errors'    => ['There was a problem in selecting the schedule.'],
                'message'   => $e->getMessage()
            ], 500);    
        }
    }

    public function fetch_inactive_schedules(Request $request) {
        $paginate = $request->paginate ? intval($request->paginate) : env('DEFAULT_PAGECOUNT');

        return response()->json([
            'data' => ScheduleTitle::where('active_schedule', 0)->where('title', 'LIKE', '%'.$request->keyword.'%')->paginate($paginate)
        ]); 
    }

    public function fetch_current_active(Request $request) {
        $active_schedule = ScheduleTitle::where('active_schedule', 1)->first();
        return response()->json([
            'data'  => $active_schedule
        ]);
    }

    public function init_list(Request $request) {
        $paginate = $request->paginate ? intval($request->paginate) : env('DEFAULT_PAGECOUNT');
        return response()->json([
            'data'  => ScheduleTitle::orderBy('id', 'desc')->paginate($request)
        ]);
    }

    public function search(Request $request) {
        $paginate = $request->paginate ? intval($request->paginate) : env('DEFAULT_PAGECOUNT');
        return response()->json([
            'data'  => ScheduleTitle::where('title', 'LIKE', '%'.$request->keyword.'%')->paginate($paginate)
        ]);
    }

}
