<?php

namespace Suiterus\Adg\Controllers\SM;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Suiterus\Adg\Models\SM\Corporation_history;

class CorporationHistoryController extends Controller
{
    // ** fetch all 
    public function fetch_corporation_history(Request $req){

        $paginate = $req->paginate ? intval($req->paginate) : env('DEFAULT_PAGECOUNT');

        $records = Corporation_history::with(['user' => function($query){

            $query->select('id', 'name')->without('permissions', 'roles', 'storage', 'supervisor','employeeMetaInfo');

        }])->whereHas('user')->whereHas('corporation')->where('user_id', $req->user_id)->orderBy('created_at', 'desc')->paginate($paginate);

        return response()->json([
            'message'   =>  "Fetch successfully",
            'data'   =>  $records
        ]);

    }

}
