<?php

namespace Suiterus\Adg\Controllers\SM;

use Illuminate\Database\Eloquent\ModelNotFoundException as ME;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Validator;
use Exception;
use DB;
use Suiterus\Adg\Models\SM\Corporation;

class CorporationController extends Controller
{
    
    public function create_corporation(Request $req) {

        $valid = Validator::make($req->all(),[
            'name'    =>  'required|string|unique:adg_db.corporations,name,NULL,id,deleted_at,NULL',
            'status' => 'integer|required'
        ],[
            'name.unique'   =>  $req->name.' is already taken.',
        ]);
        if($valid->fails()){
            return response()->json([
                'errors'    =>  $valid->errors()
            ],400);
        }
        DB::beginTransaction();
        try {
            $corporation = Corporation::create([
                'name' => $req->name,
                'description' => $req->description,
                'status' => $req->status
            ]);
            DB::commit();
            $user = $req->user();
            return response()->json([
                'text'  =>  $req->name.' created successfully!'
            ]);
        } catch (Exception $e) {
            DB::rollback();
            return response()->json([
                'errors'    =>  [ 'Can`t create your entry as of now. Contact the developer to fix it. Error Code : SM-comp-0x01' ],
                'msg'   =>  $e->getMessage()
            ],500);
        }
    }

    public function init_list_corporation(){
        return response()->json([
            'data'  =>  Corporation::orderBy('id', 'desc')->paginate(5)
        ]);
    }

    public function search_corporation_name(Request $req){
        return response()->json([
            'data'  =>  Corporation::where('name', 'LIKE', '%'.$req->keyword.'%')->paginate(5)
        ]);
    }

    public function edit_corporation(Request $req){
        $valid = Validator::make($req->all(),[
            'name'      =>  'required|string|min:4|unique:adg_db.corporations,name,'.$req->id.',id,deleted_at,NULL',
            'status'    => 'integer|required'
        ]);
        if($valid->fails()){
            return response()->json([
                'errors'    =>  $valid->errors()
            ],400);
        }
        DB::beginTransaction();
        try{
            try{
                $perms = Corporation::findOrFail($req->id);
                $perms->name = $req->name;
                $perms->description = $req->description;
                $perms->status = $req->status;
                $perms->save();
                DB::commit();
                return response()->json([
                    'text'  =>  $req->name.' has been updated.'
                ]);
            }catch(ME $ee){
                DB::rollback();
                return response()->json([
                    'errors'    =>  [ 'Corporation doesnt exists.' ],
                ],400);
            }
        }catch(Exception $e){
            DB::rollback();
            return response()->json([
                'errors'    =>  [ 'There is a problem in updating a Corporation.' ],
                'msg'       =>  $e->getMessage()
            ],500);
        }
    }

    public function delete_corporation(Request $req){
        DB::beginTransaction();
        try{
            $perm = Corporation::findOrFail($req->id);
            $perm->delete();
            DB::commit();
            return response()->json([
                'text'  =>  'Corporation has been deleted.'
            ]);
        }catch(ME $ee){
            DB::rollback();
            return response()->json([
                'errors'    =>  [ 'Corporation doesnt exists.' ],
            ],400);
        }
    }

}