<?php

namespace Suiterus\Adg\Controllers\SM;

use Exception;
use Illuminate\Http\Request;
use App\Traits\Logs\HasCustomLogs;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Suiterus\Adg\Models\Activity\Activity;
use Suiterus\Adg\Models\SM\BulkProfileRules;

class BulkProfileRulesController extends Controller
{
    use HasCustomLogs;
    
    public function fetch(){
        return response()->json([
            'data'  => BulkProfileRules::get()
        ]); 
    }

    public function update(Request $req){

        DB::beginTransaction();
        try {
            BulkProfileRules::query()->update([
                "is_required" => false
            ]);

            foreach ($req->all() as $key) {
                $bulkProfile = BulkProfileRules::find($key['id']);
                $bulkProfile->is_required = true;

                $this->logCustomMessage(
                    'update_import_bulk_profile',
                    $bulkProfile,
                    Auth::user()->name . ' updated the ' . $key['name'],
                    $bulkProfile,
                    'Update import bulk profile',
                    new Activity()
                );

                $bulkProfile->save();
            }
           
            DB::commit();
            $user = $req->user();
            return response()->json([
                'text'  => 'Required fields created successfully!.'
            ]);
        } catch (Exception $e) {
            DB::rollback();
            return response()->json([
                'errors'    =>  [ 'Can`t create your entry as of now. Contact the developer to fix it. Error Code : SM-comp-0x01' ],
                'msg'   =>  $e->getMessage()
            ],500);
        }
    }

}
