<?php

namespace Suiterus\Adg\Controllers\SM;

use Illuminate\Database\Eloquent\ModelNotFoundException as ME;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Exception;
use Illuminate\Support\Facades\DB;

use Suiterus\Adg\Models\SM\Branch;

class BranchController extends Controller
{

    public function create_branch(Request $req) {

        $valid = Validator::make($req->all(),[
            'name'    =>  'required|string|unique:adg_db.branches,name,NULL,id,deleted_at,NULL',
            'status' => 'integer|required'
        ],[
            'name.unique'   =>  $req->name.' is already taken.',
        ]);
        if($valid->fails()){
            return response()->json([
                'errors'    =>  $valid->errors()
            ],400);
        }
        DB::beginTransaction();
        try {
            $branch = Branch::create([
                'name' => $req->name,
                'description' => $req->description,
                'status' => $req->status
            ]);
            DB::commit();
            return response()->json([
                'text'  =>  $req->name.' created successfully.'
            ]);
        } catch (Exception $e) {
            DB::rollback();
            return response()->json([
                'errors'    =>  [ 'Can`t create your entry as of now. Contact the developer to fix it. Error Code : SM-comp-0x01' ],
                'msg'   =>  $e->getMessage()
            ],500);
        }
    }

    public function init_list_branch(){
        return response()->json([
            'data'  =>  Branch::orderBy('id', 'desc')->paginate(5)
        ]);
    }

    public function search_branch_name(Request $req){
        return response()->json([
            'data'  =>  Branch::where('name', 'LIKE', '%'.$req->keyword.'%')->paginate(5)
        ]);
    }

    public function edit_branch(Request $req){
        $valid = Validator::make($req->all(),[
            'name'      =>  'required|string|min:4|unique:adg_db.branches,name,'.$req->id.',id,deleted_at,NULL',
            'status'    => 'integer|required'
        ]);
        if($valid->fails()){
            return response()->json([
                'errors'    =>  $valid->errors()
            ],400);
        }
        DB::beginTransaction();
        try{
            try{
                $perms = Branch::findOrFail($req->id);
                $perms->name = $req->name;
                $perms->description = $req->description;
                $perms->status = $req->status;
                $perms->save();
                DB::commit();
                return response()->json([
                    'text'  =>  $req->name.' has been updated.'
                ]);
            }catch(ME $ee){
                DB::rollback();
                return response()->json([
                    'errors'    =>  [ 'Branch doesnt exists.' ],
                ],400);
            }
        }catch(Exception $e){
            DB::rollback();
            return response()->json([
                'errors'    =>  [ 'There is a problem in updating a Branch.' ],
                'msg'       =>  $e->getMessage()
            ],500);
        }
    }

    public function delete_branch(Request $req){
        DB::beginTransaction();
        try{
            $perm = Branch::findOrFail($req->id);
            $perm->delete();
            DB::commit();
            return response()->json([
                'text'  =>  'Branch has been deleted.'
            ]);
        }catch(ME $ee){
            DB::rollback();
            return response()->json([
                'errors'    =>  [ 'Branch doesnt exists.' ],
            ],400);
        }
    }

}
