<?php

namespace Suiterus\Adg\Controllers\Promotion;

use App\Http\Classes\NotificationMessage;
use App\Http\Controllers\Controller;
use App\Traits\Logs\HasCustomLogs;
use Exception;
use Validator;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Suiterus\Adg\Models\Activity\Activity;
use Suiterus\Adg\Models\Promotion\PromotionApplication;
use Suiterus\Adg\Services\Promotion\PromotionService;

class SupplementalController extends Controller
{
    use HasCustomLogs;
    public function create_request(Request $req)
    {

        $valid = Validator::make($req->all(), [
            'application_id' => 'required|integer|exists:' . env('ADG_DB_CONNECTION') . '.promotion_application,id',
        ]);

        if ($valid->fails()) {
            return response()->json([
                'errors' => $valid->errors()
            ], 400);
        }

        DB::beginTransaction();

        try {
            $application = PromotionApplication::where('id', $req->application_id)->with('user','phs')->first();

            $user = $application->user;
            $fullName = $user->name;

            $promotionService = new PromotionService();

            $promotionService->create_user_requirements(
                $application->id, 
                $req->supplemental_req_id,
                $req->supplemental_detail_id,
                $req->supplemental_completion_id
            );

            $application->process->update([
                'description' => $req->message,
            ]);

            $this->logCustomMessage(
                'create_application_requirements',
                $application,
                Auth::user()->name . ' has created a requirement for ' . $fullName,
                $application,
                'Create application requirements',
                new Activity()
            );

            NotificationMessage::notifySenderAndReceiver('Create Requirements', $application->user_id, Auth::id());

            DB::commit();
            return response()->json([
                'text' => 'New request record has been created.'
            ]);


        } catch (Exception $e) {
            DB::rollBack();
            return response()->json([
                'errors' => ['The request could not be process.'],
                'message' => $e->getMessage(),
            ], 500);
        }

    }
}