<?php

namespace Suiterus\Adg\Controllers\PDS;

use Exception;
use Carbon\Carbon;
use App\Models\User;
use Illuminate\Http\Request;
use App\Enums\Log\PDSLogType;
use App\Enums\CorporationList;
use App\Helper\InitialsExtractor;
use App\Traits\Logs\HasCustomLogs;
use Illuminate\Support\Facades\DB;
use Suiterus\Adg\Models\SM\Branch;
use Suiterus\Hrjp\Models\Position;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Suiterus\Adg\Models\SM\Division;
use Suiterus\Adg\Models\SM\Department;
use Suiterus\Adg\Models\SM\Corporation;
use Suiterus\Adg\Models\SM\EmployeeType;
use Illuminate\Support\Facades\Validator;
use Suiterus\Adg\Models\SM\ScheduleTitle;
use Suiterus\Adg\Models\Activity\Activity;
use MikeMcLin\WpPassword\Facades\WpPassword;
use Suiterus\Adg\Models\EMI\EmployeeMetaInfo;
use Suiterus\Dms\Models\Repositories\Section;
use Suiterus\Adg\Models\SM\DesignationHistory;
use Suiterus\Adg\Models\EMI\EmployeeExtraField;
use Suiterus\Dms\Models\Repositories\SectionAccess;
use App\Services\AccountSyncing\WpAccountSyncService;
use Suiterus\Adg\Models\EMI\EmployeeExtraFieldColumn;
use Suiterus\Adg\Models\Timekeeping\EmployeeSchedule;
use Suiterus\Adg\Controllers\Services\LeaveCreditService;
use Suiterus\Adg\Controllers\Approvals\Services\COCPointService;

class PersonalDataSheetController extends Controller
{

    use HasCustomLogs;
    
    public function validation()
    {
        $countBranch = Branch::first();
        $countCorporation = Corporation::first();
        $countDepartment = Department::first();
        $countDivision = Division::first();
        $countEmployeeType = EmployeeType::first();
        $countPosition = Position::first();
        $countSchedule = ScheduleTitle::where('active_schedule', 1)->first();
        if ($countBranch != '' && $countCorporation != '' && $countDepartment != '' && $countDivision != '' && $countEmployeeType != '' && $countPosition != '' && $countSchedule != '') {
            return response()->json([
                'message'    => 'success',
            ]);
        } else {
            return response()->json([
                'errors'    => ['Please configure branch, corporation, department, division, position, employee type, and set a default schedule before filling out.'],
            ], 400);
        }
    }

    public function create(Request $request, $isCreateUser = true, $user = null)
    {

        $personalInformation = $request->personalInformation;
        $familyBackground = $request->familyBackground;
        $educationalBackground = $request->educationalBackground;
        $civilServices = $request->civilServices;
        $workExperiences = $request->workExperiences;
        $voluntaryWorks = $request->voluntaryWorks;
        $learningDevelopments = $request->learningDevelopments;
        $otherInformation = $request->otherInformation;
        $choices = $request->choices;
        $references = $request->references;
        $governmentID = $request->governmentID;

        foreach ($personalInformation['personalInformationForm']['info'] as $key) {
            if (array_key_exists('entityName', $key)) {
                if ($key['entityName'] == 'first_name') {
                    $first_name = $key['value'];
                } else if ($key['entityName'] == 'last_name') {
                    $last_name = $key['value'];
                } else if ($key['entityName'] == 'email') {
                    $email = $key['value'];
                } else if ($key['entityName'] == 'employee_no') {
                    $employee_no = $key['value'];
                } else if ($key['entityName'] == 'date_of_birth') {
                    $date_of_birth = $key['value']; //Y-m-d
                }
            }
        }

        if ($isCreateUser) {
            $isEmailExist = User::where('email', $email)->get();
            $email = ($isEmailExist->count() > 0 || $email === '' || strtoupper($email) === 'N/A' || $email === null || !filter_var($email, FILTER_VALIDATE_EMAIL)) ? $this->generateEmail($first_name, $last_name) : $email;
        }

        // Two DB transactions are required as they are in different databases as we are also using the primary key of the users table to access other tables in different databases. Using one transaction causes MySQL transaction lock time.
        try {
            DB::connection(env('DB_CONNECTION'))->beginTransaction();
            DB::connection(env('ADG_DB_CONNECTION'))->beginTransaction();

            if ($isCreateUser) {
                $user = User::create([
                    'name'  =>  $first_name . ' ' . $last_name,
                    'email' =>  $email,
                    'password' => bcrypt('user'),
                    'email_verified_at' => now()
                ]);

                $day = Carbon::parse($date_of_birth)->format('d');
                $month = Carbon::parse($date_of_birth)->format('m');
                $password = $day . InitialsExtractor::getInitials($first_name) . $month;
                $lowerFirstName = strtolower($first_name);

                WpAccountSyncService::syncAccountsToWordpress([
                    'user_login' => preg_replace('/\s+/', '.', $lowerFirstName),
                    'user_pass' => WpPassword::make($password),
                    'user_nicename' => preg_replace('/\s+/', '.', $lowerFirstName),
                    'user_email' => $email,
                    'user_url' => '',
                    'user_registered' => Carbon::now(),
                    'user_activation_key' => '',
                    'user_status' => 0,
                    'display_name' => $first_name . ' ' . $last_name,
                ]);

                //give role
                $user->assignRole('Employee');
                //give permissions
                $user->syncPermissions(1);
            }

            DB::connection(env('DB_CONNECTION'))->commit();
            if ($request->sector == 'public') {
                $division = $request->companyDetails['form'][0]['value'];
                $department = $request->companyDetails['form'][1]['value'];
                $employeeType = $request->employeeTypePosition['form'][0]['value'];
                $position = $request->employeeTypePosition['form'][1]['value'];
                $itemCode = $request->employeeTypePosition['form'][2]['value'];
            } else {
                $corporation = $request->companyDetails['form'][0]['value'];
                $branch = $request->companyDetails['form'][1]['value'];
                $division = $request->companyDetails['form'][2]['value'];
                $department = $request->companyDetails['form'][3]['value'];
                $employeeType = $request->employeeTypePosition['form'][0]['value'];
                $position = $request->employeeTypePosition['form'][1]['value'];
            }

            if ($isCreateUser) {
                $nkti = Corporation::where('employer_id', CorporationList::NKTI)->first();
                if ($nkti) {
                    $corp_id = $nkti->id;
                }
                //Employee Meta Info
                $employeeMetaInfo = [
                    'user_id' => $user->id,
                    'employee_id' => $employee_no,
                    'employee_type' => $employeeType,
                    'branch_id' =>  $branch ?? null,
                    'division_id' => $division,
                    'department_id' => $department,
                    'salary_id' => null,
                    'item_code_id' => $itemCode ?? null,
                    'date_hired'  => date('Y-m-d'),
                    'position_id' => $position,
                    'created_by' => Auth::id()
                ];

                if ($request->sector == 'public') {
                    $employeeMetaInfo['corp_id'] = $corp_id;
                } else {
                    $employeeMetaInfo['corp_id'] = $corp_id ?? $corporation;
                }
                $create = EmployeeMetaInfo::create($employeeMetaInfo);

                $this->logCustomMessage(
                    'create_pds',
                    $create,
                    Auth::user()->name . ' created a new PDS',
                    $create,
                    PDSLogType::CREATE,
                    new Activity()
                );
                //uncomment this code if you want to assign default schedule for the employee
                // $active_schedule = ScheduleTitle::where('active_schedule', 1)->first();

                // EmployeeSchedule::create([
                //     'user_id'               => $user->id,
                //     'schedule_template_id'  => $active_schedule->id,
                //     'created_by'            => Auth::id()
                // ]);

                //insert to folder

                $activeFolderId = Section::where("name","Active Employee")->pluck('id')->first();

                $folderName = $employee_no.' - '. $first_name . ' ' . $last_name;

                $hasEmployeeFolder = Section::where([
                    ['name', $folderName], ['parent_id', $activeFolderId]
                ])->first();
                
                if (!$hasEmployeeFolder) {
                    $folder = Section::create([
                        'name' =>  $employee_no.' - '. $first_name . ' ' . $last_name,
                        'parent_id' => $activeFolderId ,
                        'type' => 1,
                        "status" => 1,
                        "created_by" => Auth::id(),
                        "created_at" => now(),
                        "updated_at" => now()
                    ]);    
            
                    $employeeFolder = Section::where('name', $folder->name)->first();
                
                    $folderAccess = [
                        "section_id" => $employeeFolder['id'],
                        'user_id' => Auth::id(),
                        'access_level' => 1,
                        "created_at" => now(),
                        "updated_at" => now()
                    ];
                    
                    SectionAccess::insert($folderAccess);
                }
            }
            // This snippet inserts personal information key
            foreach ($personalInformation as $info => $value) {
                if ($info != "title") {

                    // if statement for tablename with similar JSON structure while the else if has different json structure
                    if ($personalInformation[$info]['tableName'] == 'personal_information' || $personalInformation[$info]['tableName'] == 'other_information' || $personalInformation[$info]['tableName'] == 'pds_choices') {

                        $employeeExtraField = $this->insertEmployeeExtraField($user, $personalInformation[$info]['tableName']);

                        foreach ($personalInformation[$info]['info'] as $key => $value) {
                            if (!$value['skip']) {
                                $this->insertEmployeeExtraFieldColumn($employeeExtraField, $value);
                            }
                        }

                        // This is only unique for radio buttons with other details and similar json structure
                        if ($personalInformation[$info]['tableName'] == 'pds_choices') {
                            foreach ($personalInformation[$info]['info'] as $key => $value) {
                                if (!$value['skip']) {
                                    EmployeeExtraFieldColumn::create([
                                        'eef_id' => $employeeExtraField->id,
                                        'field_name' => $value['otherDetails']['entityName'] ?? 'N/A',
                                        'field_value' => $value['otherDetails']['value'] ?? 'N/A',
                                        'field_type' =>  $value['otherDetails']['type'] ?? 'N/A',
                                        'field_label' =>  $value['otherDetails']['label'] ?? 'N/A',
                                        'field_status' => 1,
                                        'created_by' => Auth::id(),
                                    ]);
                                    
                                }
                            }
                        }
                    } else if ($personalInformation[$info]['tableName'] == 'addresses') {
                        foreach ($personalInformation[$info]['info'] as $key => $value) {

                            $tableName = $value['title'] == 'Residential Address' ? 'residential_address' : 'permanent_address';

                            $employeeExtraField = $this->insertEmployeeExtraField($user, $tableName);

                            foreach ($value['addressInfo'] as $key => $value) {
                                if (!$value['skip']) {
                                   $this->insertEmployeeExtraFieldColumn($employeeExtraField, $value);
                                }
                            }  
                        }
                    }
                }
            }



            // This snippet inserts Family Background key
            foreach ($familyBackground as $info => $value) {
                if ($info != 'title') {
                    if ($info == 'children') {
                        foreach ($familyBackground[$info] as $key => $value) {

                            $employeeExtraField = $this->insertEmployeeExtraField($user, $value['tableName']);

                            foreach ($value['info'] as $key => $value) {
                                if (!$value['skip']) {
                                    $this->insertEmployeeExtraFieldColumn($employeeExtraField, $value);
                                }
                            }
                        }
                    } else {

                        $employeeExtraField = $this->insertEmployeeExtraField($user, $familyBackground[$info]['tableName']);

                        foreach ($value['info'] as $key => $value) {
                            if (!$value['skip']) {
                                $this->insertEmployeeExtraFieldColumn($employeeExtraField, $value);
                            }
                        }
                    }
                }
            }

            foreach ($educationalBackground as $key => $value) {
                if ($key != 'title') {
                    $tableName = $key;
                    foreach ($educationalBackground[$key] as $key => $value) {

                        $employeeExtraField = $this->insertEmployeeExtraField($user, $tableName);

                        foreach ($value as $education => $value) {
                            foreach ($value['info'] as $key => $value) {
                                if (!$value['skip']) {
                                    $this->insertEmployeeExtraFieldColumn($employeeExtraField, $value);
                                }
                            }
                        }
                    }
                }
            }

            $this->insertC2AndC3($user, $civilServices);
            $this->insertC2AndC3($user, $workExperiences);
            $this->insertC2AndC3($user, $voluntaryWorks);
            $this->insertC2AndC3($user, $learningDevelopments);
            $this->insertC2AndC3($user, $otherInformation);

            $employeeExtraField = $this->insertEmployeeExtraField($user, 'choices');



            foreach ($choices as $value) {
                foreach ($value['choices'] as $value) {
                    $choiceInfo = [];
                    $choiceInfo['entityName'] = $value['entityName'];
                    $choiceInfo['value'] = $value['value'];
                    $choiceInfo['type'] = 'radio';

                    $this->insertEmployeeExtraFieldColumn($employeeExtraField, $choiceInfo);

                    $choiceDetails = [];
                    $choiceDetails['entityName'] = $value['choiceDetails']['entityName'];
                    $choiceDetails['value'] = $value['choiceDetails']['value'];
                    $choiceDetails['type'] = 'text';

                    $this->insertEmployeeExtraFieldColumn($employeeExtraField, $choiceDetails);
                }
            }

            foreach ($references as $value) {
                $employeeExtraField = $this->insertEmployeeExtraField($user, $value['tableName']);
                foreach ($value as $key => $info) {
                    if ($key != 'tableName') {
                        foreach ($value[$key] as $key => $value) {
                            $this->insertEmployeeExtraFieldColumn($employeeExtraField, $value);
                        }
                    }
                }
            }

            foreach ($governmentID as $key => $info) {
                $employeeExtraField = $this->insertEmployeeExtraField($user, $info['tableName']);
    
                foreach ($info as $key => $value) {
                    if ($key != 'tableName') {
                        foreach ($info[$key] as $key => $value) {
                            if ($key == 'info') {
                                foreach ($value as $key => $value) {
                                    if (!$value['skip']) {
                                        $this->insertEmployeeExtraFieldColumn($employeeExtraField, $value);
                                    }
                                }
                            }
                        }
                    }
                }
            }

            $leave_service = new LeaveCreditService;
            $leave_service->initializeEmployeeBalance($user);

            $coc_service = new COCPointService;
            $coc_service->initializeCOCPoints($user);

            DB::connection(env('ADG_DB_CONNECTION'))->commit();
            return $user;
        } catch (\Throwable $th) {
            DB::connection(env('DB_CONNECTION'))->rollBack();
            DB::connection(env('ADG_DB_CONNECTION'))->rollBack();
            return response()->json([
                'error' => $th->getMessage(),
                'line' => $th->getLine(),
                'user' => $user
            ], 400);
        } catch (Exception $e) {
            DB::connection(env('DB_CONNECTION'))->rollBack();
            DB::connection(env('ADG_DB_CONNECTION'))->rollBack();
            return response()->json([
                'error' => $e->getMessage(),
                'line' => $e->getLine(),
                'user' => $user
            ], 400);
        }
    }


    public function createFiles(Request $request)
    {

        $files = $request->all();

        $validator = Validator::make($files, [
            'diploma_file' => 'required|nullable|file|mimes:pdf,doc,docx|max:50000',
            'birth_file' => 'required|nullable|file|mimes:pdf,doc,docx|max:50000',
            'civil_file' => 'required|nullable|file|mimes:pdf,doc,docx|max:50000',
            'nbi_file' => 'required|nullable|file|mimes:pdf,doc,docx|max:50000',
            'training_file' => $files['training_file'] == 'null' ? '' : 'nullable|file|mimes:pdf,doc,docx|max:50000',
            'resume_file' => $files['work_file'] == 'null' ? '' : 'nullable|file|mimes:pdf,doc,docx',
            'work_file' => $files['work_file'] == 'null' ? '' : 'nullable|file|mimes:pdf,doc,docx'
        ]);


        $user = User::find($files['user']);

        if ($validator->fails()) {
            $this->rollBack($user);
            return response()->json([
                'error' => $validator->errors()
            ], 400);
        }

        $employeeExtraField = $this->insertEmployeeExtraField($user, 'file_attachments');

        foreach ($request->all() as $key => $value) {
            if ($files[$key] != 'null' && $key != 'user' && $files[$key] != null && isset($files[$key])) {
                $path = $files[$key]->store('pds_file_attachment/' . $user->id . '/' . $key);
                DB::beginTransaction();
                try {
                    $create = EmployeeExtraFieldColumn::create([
                        'eef_id' => $employeeExtraField->id,
                        'field_name' => $key,
                        'field_value' => $path,
                        'field_type' =>  'file',
                        'field_status' => 1,
                        'created_by' => Auth::id(),
                    ]);

                    $this->logCustomMessage(
                        'create_file_pds',
                        $create,
                        Auth::user()->name . ' created a ' . $key,
                        $create,
                        PDSLogType::CREATE_FILE,
                        new Activity()
                    );

                    DB::commit();
                } catch (\Exception $e) {
                    $this->rollBack($user);
                    return response()->json([
                        'error' => $e->getMessage(),
                        'line' => $e->getLine(),
                        'user' => $user
                    ], 400);
                } catch (\Throwable $th) {
                    $this->rollBack($user);
                    return response()->json([
                        'error' => $th->getMessage(),
                        'line' => $th->getLine(),
                        'user' => $user
                    ], 400);
                }
            } else if ($key != 'user') {
                DB::beginTransaction();
                try {
                    EmployeeExtraFieldColumn::create([
                        'eef_id' => $employeeExtraField->id,
                        'field_name' => $key,
                        'field_value' => 'N/A',
                        'field_type' =>  'file',
                        'field_status' => 1,
                        'created_by' => Auth::id(),
                    ]);

                    DB::commit();
                } catch (\Exception $e) {
                    $this->rollBack($user);
                    return response()->json([
                        'error' => $e->getMessage(),
                        'line' => $e->getLine(),
                        'user' => $user
                    ], 400);
                } catch (\Throwable $th) {
                    $this->rollBack($user);
                    return response()->json([
                        'error' => $th->getMessage(),
                        'line' => $th->getLine(),
                        'user' => $user
                    ], 400);
                }
            }
        }
    }

    // Because DB transactions restrict deletion in the create function, a function was created to roll back the user.This function will be triggered if the create function fails.
    public function rollBack($user)
    {
        if ($user == null || !isset($user)) {
            return response()->json([
                'error' => 'User does not exist'
            ], 400);
        }
        $user->employeeMetaInfo->forceDelete();
        $employeeExtraField = EmployeeExtraField::where('user_id', $user->id);
        DesignationHistory::where('user_id', $user->id)->forceDelete();
        $employeeExtraField = EmployeeExtraField::where('user_id', $user->id);
        foreach ($employeeExtraField->get() as $value) {
            EmployeeExtraFieldColumn::where('eef_id', $value['id'])->forceDelete();
        }
        $employeeExtraField->forceDelete();
        $user->forceDelete();
    }

    public function rollBackUser(Request $request)
    {
        if ($request->id == null || !isset($request->id)) {
            return response()->json([
                'error' => 'User does not exist'
            ], 400);
        }
        User::find($request->id)->forceDelete();
    }

    public function generateEmail($first_name, $last_name)
    {

        $i = 0;
        while (true) {
            if ($i == 0) {
                $email = strtolower(str_replace(' ', '.', $first_name) . '.' . $last_name . '@nkti.gov.ph');
            } else if ($i > 0) {
                $date = date_create();
                $email = strtolower(str_replace(' ', '.', $first_name) . '.' . $last_name . now()->timestamp . '@nkti.gov.ph');
            }

            $user = User::where('email', $email)->get();

            if ($user->count() == 0) {
                return $email;
            }

            $i++;
        }
    }

    public function insertC2AndC3($user, $information)
    {
        foreach ($information as $key => $info) {
            $employeeExtraField = $this->insertEmployeeExtraField($user, $info['tableName']);

            foreach ($info as $key => $value) {
                if ($key != 'tableName') {
                    foreach ($info[$key] as $key => $value) {
                        if ($key == 'info') {
                            foreach ($value as $key => $value) {
                                if (!$value['skip']) {
                                    $this->insertEmployeeExtraFieldColumn($employeeExtraField, $value);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public function insertEmployeeExtraField($user, $tableName)
    {
        $employeeExtraField = EmployeeExtraField::create([
            'user_id' => $user->id,
            'table_name' => $tableName,
            'created_by' => Auth::id()
        ]);

        return $employeeExtraField;
    }

    public function insertEmployeeExtraFieldColumn($employeeExtraField, $value)
    {
        EmployeeExtraFieldColumn::create([
            'eef_id' => $employeeExtraField->id,
            'field_name' => $value['entityName'] ?? 'N/A',
            'field_value' => $value['value'] ?? 'N/A',
            'field_type' =>  $value['type'] ?? 'N/A',
            'field_label' =>  $value['label'] ?? 'No label',
            'field_status' => 1,
            'created_by' => Auth::id(),
        ]);
    }
}
