<?php

namespace Suiterus\Adg\Controllers\PDS;

use App\Models\User;
use Illuminate\Http\Request;
use App\Enums\Log\PDSLogType;
use App\Traits\Logs\HasCustomLogs;
use Illuminate\Support\Facades\App;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Maatwebsite\Excel\Facades\Excel;
use Suiterus\Adg\Models\Activity\Activity;
use Suiterus\Hrjp\Models\Position_history;
use Suiterus\Adg\Models\PDS\PDSPerPosition;
use Suiterus\Adg\Exports\PDS\PDSExportsAdmin;


class PDSPrintPerPositionController extends Controller
{

    use HasCustomLogs; 
    
    public function print_pds_admin(Request $request){
        $history = Position_history::whereId($request->id)->where('user_id', $request->user_id)->where('position_id', $request->position_id)->first();

        $user = User::where('id',$history->user_id)->first();

        $record = 0;
        $eefc_id = [];
        foreach($history->pdsPerPosition as $pds){
            array_push($eefc_id,$pds->eefc_id);
        }

        $response = array();
        $personal_informations = array();
        $permanent_addresses = array();
        $residential_addresses = array();
        $pds_choices = array();
        $other_informations = array();
        $spouses = array();
        $children_arr = array();
        $fathers = array();
        $mothers = array();
        $elementaries_arr = array();
        $secondaries_arr = array();
        $vocationals_arr = array();
        $colleges_arr = array();
        $graduates_arr = array();
        $civil_services_arr = array();
        $work_experiences_arr = array();
        $voluntary_works_arr = array();
        $learning_developments_arr = array();
        $skills_hobbies_arr = array();
        $choices = array();
        $references_arr = array();
        $government_ids = array();
        //$file_attachment = array();

        $children = $user->children;
        $this->filter_position_history($children, $history->id, $record, $eefc_id);

        $elementaries = $user->elementary;
        $this->filter_position_history($elementaries, $history->id, $record, $eefc_id);

        $secondaries = $user->secondary;
        $this->filter_position_history($secondaries, $history->id, $record, $eefc_id);

        $vocationals = $user->vocational;
        $this->filter_position_history($vocationals, $history->id, $record, $eefc_id);

        $colleges = $user->college;
        $this->filter_position_history($colleges, $history->id, $record, $eefc_id);
       
        $graduates = $user->graduate;
        $this->filter_position_history($graduates, $history->id, $record, $eefc_id);

        $civilServices = $user->civilService;
        $this->filter_position_history($civilServices, $history->id, $record, $eefc_id);
       
        $workExperiences = $user->workExperience;
        $this->filter_position_history($workExperiences, $history->id, $record, $eefc_id);

        $voluntaryWorks = $user->voluntaryWork;
        $this->filter_position_history($voluntaryWorks, $history->id, $record, $eefc_id);

        $learningDevelopments = $user->learningDevelopment;
        $this->filter_position_history($learningDevelopments, $history->id, $record, $eefc_id);

        $skillHobbies = $user->skillHobby;
        $this->filter_position_history($skillHobbies, $history->id, $record, $eefc_id);

        $references = $user->reference;
        $this->filter_position_history($references, $history->id, $record, $eefc_id);



        $personal_information = PDSPerPosition::where('position_history_id', $history->id)->whereHas('employeeExtraFieldColumn.employeeExtraField', function($query){
            $query->where('table_name', 'personal_information');
        })->get();

        $pds_choice = PDSPerPosition::where('position_history_id', $history->id)->whereHas('employeeExtraFieldColumn.employeeExtraField', function($query){
            $query->where('table_name', 'pds_choices');
        })->get();

        $other_information = PDSPerPosition::where('position_history_id', $history->id)->whereHas('employeeExtraFieldColumn.employeeExtraField', function($query){
            $query->where('table_name', 'other_information');
        })->get();

        $permanent_address = PDSPerPosition::where('position_history_id', $history->id)->whereHas('employeeExtraFieldColumn.employeeExtraField', function($query){
            $query->where('table_name', 'permanent_address');
        })->get();

        $residential_address = PDSPerPosition::where('position_history_id', $history->id)->whereHas('employeeExtraFieldColumn.employeeExtraField', function($query){
            $query->where('table_name', 'residential_address');
        })->get();

        $spouse = PDSPerPosition::where('position_history_id', $history->id)->whereHas('employeeExtraFieldColumn.employeeExtraField', function($query){
            $query->where('table_name', 'spouse');
        })->get();

        $father = PDSPerPosition::where('position_history_id', $history->id)->whereHas('employeeExtraFieldColumn.employeeExtraField', function($query){
            $query->where('table_name', 'father');
        })->get();

        $mother = PDSPerPosition::where('position_history_id', $history->id)->whereHas('employeeExtraFieldColumn.employeeExtraField', function($query){
            $query->where('table_name', 'maiden_name');
        })->get();

        $choice = PDSPerPosition::where('position_history_id', $history->id)->whereHas('employeeExtraFieldColumn.employeeExtraField', function($query){
            $query->where('table_name', 'choices');
        })->get();

        $government_ids = PDSPerPosition::where('position_history_id', $history->id)->whereHas('employeeExtraFieldColumn.employeeExtraField', function($query){
            $query->where('table_name', 'government_id');
        })->get();

        foreach ($personal_information as $records => $values)
        {
            $personal_informations[$values['field_name']] = $values['field_value'];
        }

        foreach ($pds_choice as $records => $values)
        {
            $pds_choices[$values['field_name']] = $values['field_value'];
        }

        foreach ($other_information as $records => $values)
        {
            $other_informations[$values['field_name']] = $values['field_value'];
        }

        foreach ($permanent_address as $records => $values)
        {
            $permanent_addresses[$values['field_name']] = $values['field_value'];
        }

        foreach ($residential_address as $records => $values)
        {
            $residential_addresses[$values['field_name']] = $values['field_value'];
        }

        foreach ($spouse as $records => $values)
        {
            $spouses[$values['field_name']] = $values['field_value'];
        }

        foreach ($father as $records => $values)
        {
            $fathers[$values['field_name']] = $values['field_value'];
        }


        foreach ($children as $records => $key)
        {
        $childs = [];

            foreach($key->EmployeeExtraFieldColumn as $values)
            {   
                
                $childs[$values['field_name']] = $values['field_value'];

            }

        array_push($children_arr, $childs);
        }
        
        foreach ($mother as $records => $values)
        {
            $mothers[$values['field_name']] = $values['field_value'];
        }


        foreach ($elementaries as $records => $key)
        {
        $elem = [];

            foreach($key->EmployeeExtraFieldColumn as $values)
            {   
                
                $elem[$values['field_name']] = $values['field_value'];

            }

            array_push($elementaries_arr, $elem);
        }

        foreach ($secondaries as $records => $key)
        {
        $second = [];

            foreach($key->EmployeeExtraFieldColumn as $values)
            {   
                
                $second[$values['field_name']] = $values['field_value'];

            }

            array_push($secondaries_arr, $second);
        }


        foreach ($vocationals as $records => $key)
        {
        $vocation = [];
            foreach($key->EmployeeExtraFieldColumn as $values)
            {
                $vocation[$values['field_name']] = $values['field_value'];
            }

            array_push($vocationals_arr, $vocation);
        
        }

        foreach ($colleges as $records => $key)
        {
            $coll = [];
            foreach($key->EmployeeExtraFieldColumn as $values)
            {
                $coll[$values['field_name']] = $values['field_value'];
            }
            array_push($colleges_arr, $coll);
           
        }

        foreach ($graduates as $records => $key)
        {
            $grad = [];
            foreach($key->EmployeeExtraFieldColumn as $values)
            {
                $grad[$values['field_name']] = $values['field_value'];
            }
            
            array_push($graduates_arr, $grad);
        }

        foreach ($civilServices as $records => $key)
        {
        $civil = [];

            foreach($key->EmployeeExtraFieldColumn as $values)
            {   
                $civil[$values['field_name']] = $values['field_value'];
            }

        array_push($civil_services_arr, $civil);
        }

        foreach ($workExperiences as $records => $key)
        {
        $workExp = [];

            foreach($key->EmployeeExtraFieldColumn as $values)
            {   
                $workExp[$values['field_name']] = $values['field_value'];
            }

        array_push($work_experiences_arr, $workExp);
        }

        foreach ($voluntaryWorks as $records => $key)
        {
        $voluntary = [];

            foreach($key->EmployeeExtraFieldColumn as $values)
            {   
                $voluntary[$values['field_name']] = $values['field_value'];
            }

        array_push($voluntary_works_arr, $voluntary);
        }

        foreach ($learningDevelopments as $records => $key)
        {
        $learn = [];

            foreach($key->EmployeeExtraFieldColumn as $values)
            {   
                $learn[$values['field_name']] = $values['field_value'];
            }

        array_push($learning_developments_arr, $learn);
        }

        foreach ($skillHobbies as $records => $key)
        {
        $skill = [];

            foreach($key->EmployeeExtraFieldColumn as $values)
            {   
                $skill[$values['field_name']] = $values['field_value'];
            }

        array_push($skills_hobbies_arr, $skill);
        }


        foreach ($choice as $records => $values)
        {
            $choices[$values['field_name']] = $values['field_value'];
        }

        foreach ($references as $records => $key)
        {
        $refer = [];

            foreach($key->EmployeeExtraFieldColumn as $values)
            {   
                $refer[$values['field_name']] = $values['field_value'];
            }

        array_push($references_arr, $refer);
        }

        foreach ($government_ids as $records => $key)
        {
        $government_id = [];

            foreach($key->EmployeeExtraFieldColumn as $values)
            {   
                $government_id[$values['field_name']] = $values['field_value'];
            }

        array_push($government_ids, $government_id);
        }

        foreach ($government_ids as $records => $key)
        {
        $government_id = [];

            foreach($key->EmployeeExtraFieldColumn as $values)
            {   
                $government_id[$values['field_name']] = $values['field_value'];
            }

        array_push($government_ids, $government_id);
        }

        $this->logCustomMessage(
            'print_pds_per_position',
            $history,
            Auth::user()->name . ' printed the PDS',
            $history,
            PDSLogType::PRINT_POSITION,
            new Activity()
        );

        array_push($response, ['personal_informations', 'pds_choices', 'other_informations', 'permanent_addresses', 'residential_addresses',
            'spouses', 'fathers', 'mothers', 'children_arr', 'elementaries_arr', 'secondaries_arr', 'vocationals_arr', 'colleges_arr', 'graduates_arr', 'civil_services_arr',
            'work_experiences_arr', 'voluntary_works_arr', 'learning_developments_arr', 'skills_hobbies_arr', 'choices', 'references_arr', 'government_ids']);

        $pds= [
            'personal_information' => $personal_informations,
            'permanent_address' => $permanent_addresses,
            'residential_address' => $residential_addresses,
            'pds_choices' => $pds_choices,
            'other_information' => $other_informations,
            'spouse' => $spouses,
            'children' => $children_arr,
            'father' => $fathers,
            'maiden_name' => $mothers,
            'elementary' => $elementaries_arr,
            'secondary' => $secondaries_arr,
            'vocational' => $vocationals_arr,
            'college' => $colleges_arr,
            'graduate' => $graduates_arr,
            'civil_service' => $civil_services_arr,
            'work_experience' => $work_experiences_arr,
            'voluntary_work' => $voluntary_works_arr,
            'learning_development' => $learning_developments_arr,
            'skill_hobby' => $skills_hobbies_arr,
            'choice' => $choices,
            'reference' => $references_arr,
            'government_issued_id' => $government_ids

        ];
            return Excel::download(new PDSExportsAdmin($pds),  'PDS-data.xlsx');
    }


    public function filter_position_history($pds, $historyId, $record, $eefc_id){
        foreach($pds as $value){
            $data = [];
            $count = 0;
            foreach($value->employeeExtraFieldColumn as $column){
                $pds_position = PDSPerPosition::where('eefc_id', $column->id)->where('position_history_id', $historyId)->first();
                array_push($data,$pds_position);
                if(!in_array($column->id, $eefc_id)){
                    $count++;
                }

                if($count == count($value->employeeExtraFieldColumn)){
                    unset($pds[$record]);
                }
            }
            $value['employee_extra_field_columns'] = $data;
            $record++;
        }
        return $pds;
    }


    

}
