<?php

namespace Suiterus\Adg\Controllers\PDS;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\User;
use Suiterus\Hrjp\Models\Position_history;
use Suiterus\Adg\Models\PDS\PDSPerPosition;
use Illuminate\Support\Facades\App;


class PDSPerPositionController extends Controller
{
    //fetch
    public function fetch_pds_position(Request $request){

        $history = Position_history::whereId($request->id)->where('user_id', $request->user_id)->where('position_id', $request->position_id)->first();

        $user = User::where('id',$history->user_id)->first();

        $record = 0;
        $eefc_id = [];
        foreach($history->pdsPerPosition as $pds){
            array_push($eefc_id,$pds->eefc_id);
        }

        $children = $user->children;
        $this->filter_position_history($children, $history->id, $record, $eefc_id);

        
        $elementaries = $user->elementary;
        $this->filter_position_history($elementaries, $history->id, $record, $eefc_id);

        $secondaries = $user->secondary;
        $this->filter_position_history($secondaries, $history->id, $record, $eefc_id);

        $vocationals = $user->vocational;
        $this->filter_position_history($vocationals, $history->id, $record, $eefc_id);

        $colleges = $user->college;
        $this->filter_position_history($colleges, $history->id, $record, $eefc_id);
       
        $graduates = $user->graduate;
        $this->filter_position_history($graduates, $history->id, $record, $eefc_id);

        $civilServices = $user->civilService;
        $this->filter_position_history($civilServices, $history->id, $record, $eefc_id);
       
        $workExperiences = $user->workExperience;
        $this->filter_position_history($workExperiences, $history->id, $record, $eefc_id);

        $voluntaryWorks = $user->voluntaryWork;
        $this->filter_position_history($voluntaryWorks, $history->id, $record, $eefc_id);

        $learningDevelopments = $user->learningDevelopment;
        $this->filter_position_history($learningDevelopments, $history->id, $record, $eefc_id);

        $skillHobbies = $user->skillHobby;
        $this->filter_position_history($skillHobbies, $history->id, $record, $eefc_id);

        $references = $user->reference;
        $this->filter_position_history($references, $history->id, $record, $eefc_id);

        $governmentIDs = $user->governmentIssuedId;
        $this->filter_position_history($governmentIDs, $history->id, $record, $eefc_id);

        $pds = [
            'personal_information' => ['employee_extra_field_columns' => PDSPerPosition::where('position_history_id', $history->id)->whereHas('employeeExtraFieldColumn.employeeExtraField', function($query){
                $query->where('table_name', 'personal_information');
            })->get()],
            'pds_choices' => ['employee_extra_field_columns' => PDSPerPosition::where('position_history_id', $history->id)->whereHas('employeeExtraFieldColumn.employeeExtraField', function($query){
                $query->where('table_name', 'pds_choices');
            })->get()],
            'other_information' => ['employee_extra_field_columns' => PDSPerPosition::where('position_history_id', $history->id)->whereHas('employeeExtraFieldColumn.employeeExtraField', function($query){
                $query->where('table_name', 'other_information');
            })->get()],
            'permanent_address' => ['employee_extra_field_columns' => PDSPerPosition::where('position_history_id', $history->id)->whereHas('employeeExtraFieldColumn.employeeExtraField', function($query){
                $query->where('table_name', 'permanent_address');
            })->get()],
            'residential_address' => ['employee_extra_field_columns' => PDSPerPosition::where('position_history_id', $history->id)->whereHas('employeeExtraFieldColumn.employeeExtraField', function($query){
                $query->where('table_name', 'residential_address');
            })->get()],
            'spouse' => ['employee_extra_field_columns' => PDSPerPosition::where('position_history_id', $history->id)->whereHas('employeeExtraFieldColumn.employeeExtraField', function($query){
                $query->where('table_name', 'spouse');
            })->get()],
            'children' => $children,
            'father' => ['employee_extra_field_columns' => PDSPerPosition::where('position_history_id', $history->id)->whereHas('employeeExtraFieldColumn.employeeExtraField', function($query){
                $query->where('table_name', 'father');
            })->get()],
            'maiden_name' => ['employee_extra_field_columns' => PDSPerPosition::where('position_history_id', $history->id)->whereHas('employeeExtraFieldColumn.employeeExtraField', function($query){
                $query->where('table_name', 'maiden_name');
            })->get()],
            'elementary' => $elementaries,
            'secondary' => $secondaries,
            'vocational' => $vocationals,
            'college' => $colleges,
            'graduate' => $graduates,
            'civil_service' => $civilServices,
            'work_experience' => $workExperiences,
            'voluntary_work' => $voluntaryWorks,
            'learning_development' => $learningDevelopments,
            'skill_hobby' => $skillHobbies,
            'choice' => ['employee_extra_field_columns' => PDSPerPosition::where('position_history_id', $history->id)->whereHas('employeeExtraFieldColumn.employeeExtraField', function($query){
                $query->where('table_name', 'choices');
            })->get()],
            'reference' => $references,
            'government_issued_id' => $governmentIDs,
            'file_attachment' => ['employee_extra_field_columns' => PDSPerPosition::where('position_history_id', $history->id)->whereHas('employeeExtraFieldColumn.employeeExtraField', function($query){
                $query->where('table_name', 'file_attachments');
            })->get()]
        ];

        return response()->json([
            'text'  => 'PDS fetch successfully',
            'data'  =>  $pds
        ]);
    }

    public function filter_position_history($pds, $historyId, $record, $eefc_id){
        foreach($pds as $value){
            $data = [];
            $count = 0;
            foreach($value->employeeExtraFieldColumn as $column){
                $pds_position = PDSPerPosition::where('eefc_id', $column->id)->where('position_history_id', $historyId)->first();
                array_push($data,$pds_position);
                if(!in_array($column->id, $eefc_id)){
                    $count++;
                }

                if($count == count($value->employeeExtraFieldColumn)){
                    unset($pds[$record]);
                }
            }
            $value['employee_extra_field_columns'] = $data;
            $record++;
        }
        return $pds;
    }

    public function view_pds(Request $request){
        $history = Position_history::whereId($request->id)->where('user_id', $request->user_id)->where('position_id', $request->position_id)->first();

        $user = User::where('id',$history->user_id)->first();
        $response = array();
        $personal_informations = array();
        $permanent_addresses = array();
        $residential_addresses = array();
        $pds_choices = array();
        $other_informations = array();
        $spouses = array();
        $children = array();
        $fathers = array();
        $mothers = array();
        $elementaries = array();
        $secondaries = array();
        $vocationals = array();
        $colleges = array();
        $graduates = array();
        $civil_services = array();
        $work_experiences = array();
        $voluntary_works = array();
        $learning_developments = array();
        $skills_hobbies = array();
        $choices = array();
        $references = array();
        $government_ids = array();
        //$file_attachment = array();

        $personal_information = PDSPerPosition::where('position_history_id', $history->id)->whereHas('employeeExtraFieldColumn.employeeExtraField', function($query){
            $query->where('table_name', 'personal_information');
        })->get();

        $pds_choice = PDSPerPosition::where('position_history_id', $history->id)->whereHas('employeeExtraFieldColumn.employeeExtraField', function($query){
            $query->where('table_name', 'pds_choices');
        })->get();

        $other_information = PDSPerPosition::where('position_history_id', $history->id)->whereHas('employeeExtraFieldColumn.employeeExtraField', function($query){
            $query->where('table_name', 'other_information');
        })->get();

        $permanent_address = PDSPerPosition::where('position_history_id', $history->id)->whereHas('employeeExtraFieldColumn.employeeExtraField', function($query){
            $query->where('table_name', 'permanent_address');
        })->get();

        $residential_address = PDSPerPosition::where('position_history_id', $history->id)->whereHas('employeeExtraFieldColumn.employeeExtraField', function($query){
            $query->where('table_name', 'residential_address');
        })->get();

        $spouse = PDSPerPosition::where('position_history_id', $history->id)->whereHas('employeeExtraFieldColumn.employeeExtraField', function($query){
            $query->where('table_name', 'spouse');
        })->get();

        $father = PDSPerPosition::where('position_history_id', $history->id)->whereHas('employeeExtraFieldColumn.employeeExtraField', function($query){
            $query->where('table_name', 'father');
        })->get();

        $mother = PDSPerPosition::where('position_history_id', $history->id)->whereHas('employeeExtraFieldColumn.employeeExtraField', function($query){
            $query->where('table_name', 'maiden_name');
        })->get();

        $child= PDSPerPosition::where('position_history_id', $history->id)->whereHas('employeeExtraFieldColumn.employeeExtraField', function($query){
            $query->where('table_name', 'children');
        })->get();

        $elementary = PDSPerPosition::where('position_history_id', $history->id)->whereHas('employeeExtraFieldColumn.employeeExtraField', function($query){
            $query->where('table_name', 'elementary');
        })->get();

        $secondary = PDSPerPosition::where('position_history_id', $history->id)->whereHas('employeeExtraFieldColumn.employeeExtraField', function($query){
            $query->where('table_name', 'secondary');
        })->get();

        $vocational = PDSPerPosition::where('position_history_id', $history->id)->whereHas('employeeExtraFieldColumn.employeeExtraField', function($query){
            $query->where('table_name', 'vocational');
        })->get();

        $college = PDSPerPosition::where('position_history_id', $history->id)->whereHas('employeeExtraFieldColumn.employeeExtraField', function($query){
            $query->where('table_name', 'college');
        })->get();

        $graduate = PDSPerPosition::where('position_history_id', $history->id)->whereHas('employeeExtraFieldColumn.employeeExtraField', function($query){
            $query->where('table_name', 'graduate');
        })->get();

        $civil_service = PDSPerPosition::where('position_history_id', $history->id)->whereHas('employeeExtraFieldColumn.employeeExtraField', function($query){
            $query->where('table_name', 'civil_services');
        })->get();

        $work_experience = PDSPerPosition::where('position_history_id', $history->id)->whereHas('employeeExtraFieldColumn.employeeExtraField', function($query){
            $query->where('table_name', 'work_experience');
        })->get();

        $voluntary_work = PDSPerPosition::where('position_history_id', $history->id)->whereHas('employeeExtraFieldColumn.employeeExtraField', function($query){
            $query->where('table_name', 'voluntary_work');
        })->get();

        $learning_development = PDSPerPosition::where('position_history_id', $history->id)->whereHas('employeeExtraFieldColumn.employeeExtraField', function($query){
            $query->where('table_name', 'learning_development');
        })->get();

        $skill_hobby = PDSPerPosition::where('position_history_id', $history->id)->whereHas('employeeExtraFieldColumn.employeeExtraField', function($query){
            $query->where('table_name', 'skills_hobbies');
        })->get();

        $choice = PDSPerPosition::where('position_history_id', $history->id)->whereHas('employeeExtraFieldColumn.employeeExtraField', function($query){
            $query->where('table_name', 'choices');
        })->get();

        $reference = PDSPerPosition::where('position_history_id', $history->id)->whereHas('employeeExtraFieldColumn.employeeExtraField', function($query){
            $query->where('table_name', 'reference');
        })->get();

        $government_id = PDSPerPosition::where('position_history_id', $history->id)->whereHas('employeeExtraFieldColumn.employeeExtraField', function($query){
            $query->where('table_name', 'government_id');
        })->get();


        foreach ($personal_information as $records => $values)
        {
            array_push($personal_informations, $values);
        }

        foreach ($pds_choice as $records => $values)
        {
            array_push($pds_choices, $values);
        }

        foreach ($other_information as $records => $values)
        {
            array_push($other_informations, $values);
        }

        foreach ($permanent_address as $records => $values)
        {
            array_push($permanent_addresses, $values);
        }

        foreach ($residential_address as $records => $values)
        {
            array_push($residential_addresses, $values);
        }

        foreach ($spouse as $records => $values)
        {
            array_push($spouses, $values);
        }

        foreach ($father as $records => $values)
        {
            array_push($fathers, $values);
        }

        foreach ($mother as $records => $values)
        {
            array_push($mothers, $values);
        }

        foreach ($child as $records => $values)
        {
            array_push($children, $values);
        }

        foreach ($elementary as $records => $values)
        {
            array_push($elementaries, $values);
        }

        foreach ($secondary as $records => $values)
        {
            array_push($secondaries, $values);
        }

        foreach ($vocational as $records => $values)
        {
            array_push($vocationals, $values);
        }

        foreach ($college as $records => $values)
        {
            array_push($colleges, $values);
        }

        foreach ($graduate as $records => $values)
        {
            array_push($graduates, $values);
        }

        foreach ($civil_service as $records => $values)
        {
            array_push($civil_services, $values);
        }

        foreach ($work_experience as $records => $values)
        {
            array_push($work_experiences, $values);
        }

        foreach ($voluntary_work as $records => $values)
        {
            array_push($voluntary_works, $values);
        }

        foreach ($learning_development as $records => $values)
        {
            array_push($learning_developments, $values);
        }

        foreach ($skill_hobby as $records => $values)
        {
            array_push($skills_hobbies, $values);
        }

        foreach ($choice as $records => $values)
        {
            array_push($choices, $values);
        }

        foreach ($reference as $records => $values)
        {
            array_push($references, $values);
        }

        foreach ($government_id as $records => $values)
        {
            array_push($government_ids, $values);
        }
        
        array_push($response, ['personal_informations', 'pds_choices', 'other_informations', 'permanent_addresses', 'residential_addresses',
            'spouses', 'children', 'fathers', 'mothers', 'elementaries', 'secondaries', 'vocationals', 'colleges', 'graduates', 'civil_services',
            'work_experiences', 'voluntary_works', 'learning_developments', 'skills_hobbies', 'choices', 'references', 'government_ids']);

        $pdf = App::make('dompdf.wrapper');
        $pdf->loadView("pdf.PDSOldTrial", compact($response))->setPaper([0, 0, 1360, 600.85], 'landscape');
        
        return $pdf->stream();
    }
}
