<?php

namespace Suiterus\Adg\Controllers\PDS;

use Exception;
use Illuminate\Http\Request;
use App\Enums\Log\PDSLogType;
use App\Traits\Logs\HasCustomLogs;
use Illuminate\Support\Facades\DB;
use Suiterus\Adg\Models\SM\Remark;
use Suiterus\Adg\Models\SM\Sector;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Suiterus\Adg\Models\PDS\PDSHistory;
use Suiterus\Adg\Models\SM\SalaryGrade;
use Suiterus\Adg\Models\Activity\Activity;
use Suiterus\Adg\Models\Salary\UserSalary;
use Suiterus\Adg\Models\EMI\EmployeeMetaInfo;
use Suiterus\Adg\Models\Salary\PrivateSalary;
use Suiterus\Adg\Models\Salary\EmployeeAllowance;
use Suiterus\Adg\Models\ServiceRecord\ServiceRecord;
use Suiterus\Adg\Models\EMI\EmployeeExtraFieldColumn;

class PDSHistoryController extends Controller
{
    use HasCustomLogs; 
    
    public function resignation($clearance){
        DB::beginTransaction();
        try{
            $activeSector = Sector::where('status', 'active')->first();
            $sector = $activeSector->name;

            $oldServiceRecord = ServiceRecord::where('user_id', $clearance->user_id)->whereNull('end_date');
                $endDate = date('Y-m-d', strtotime(now()));
                $oldServiceRecord->update([
                    'end_date'  => $endDate
                ]);

            
            $totalAllowance = 0;
            
            $allowance = EmployeeAllowance::where('user_id', $clearance->user_id)->get();

            foreach($allowance as $allowances) {
                $totalAllowance += $allowances['amount'];
            }

            if($allowance === null){
                $allAllowances = 0;
            }
            else{
                $allAllowances = $totalAllowance;
            }

            if($sector == 'public'){
                $newSalary = SalaryGrade::whereHas('publicSalary', function($query) use($clearance){
                    $query->whereHas('userSalary', function($query) use($clearance){
                        $query->where([
                            ['user_id', $clearance->user_id]
                        ]);
                    });
                })->first();

                $salary = $newSalary->value;
                $salary = str_replace( ',', '', $salary);
                $annualSalary = $salary * 12;

            }
            else{
                $newSalary = PrivateSalary::whereHas('userSalary', function ($query) use($clearance){
                $query->where('user_id', $clearance->user_id);
            })->first();

                $salary = $newSalary->salary;
                $annualSalary = $salary * 12;
            }

            $employee = EmployeeMetaInfo::where('user_id', $clearance->user_id)->first();
            $remark = Remark::whereId(13)->first();
            $serviceRecord = ServiceRecord::create([
                'user_id'           =>  $clearance->user_id,
                'start_date'        =>  $clearance->updated_at, 
                'position_id'       =>  $employee->position_id,
                'salary'            =>  0,
                'allowance'         =>  $allAllowances,
                'employee_type_id'  =>  $employee->employee_type,
                'division_id'       =>  $employee->division_id,
                'remark_id'         =>  $remark->id,  //* Resignation
                'created_by'        =>  Auth::id(),
            ]);

            $employeeExtraFieldColumn = EmployeeExtraFieldColumn::whereHas('employeeExtraField', function($query) use($clearance){
                $query->where('user_id', $clearance->user_id);
            })->get();

            foreach($employeeExtraFieldColumn as $pds){
                PDSHistory::create([
                    'user_id'             =>   $clearance->user_id,
                    'service_record_id'   =>   $serviceRecord->id,
                    'eefc_id'             =>   $pds->id,
                    'field_name'          =>   $pds->field_name,
                    'field_value'         =>   $pds->field_value
                ]);
            }
                    
            $this->logCustomMessage(
                'resignation',
                $serviceRecord,
                Auth::user()->name . ' request has been process',
                $serviceRecord,
                PDSLogType::RESIGNATION,
                new Activity()
            );

            DB::commit();

        } catch(Exception $e){
            DB::rollback();
            return response()->json([
                'errors'    =>  ['The request could not be process.'],
                'message'   =>  $e->getMessage(),
                'line'      =>  $e->getLine()
            ], 500);
        }
    }
}
