<?php

namespace Suiterus\Adg\Controllers\PDS\Employee;


use PDF;
use App\Models\User;
use Illuminate\Http\Request;
use App\Enums\Log\PDSLogType;
use App\Traits\Logs\HasCustomLogs;
use Illuminate\Support\Facades\App;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Facades\Storage;
use Suiterus\Adg\Exports\PDS\PDSExports;
use Illuminate\Support\Facades\Validator;
use Suiterus\Adg\Models\Activity\Activity;

class PDSPrintController extends Controller
{

    use HasCustomLogs;
    
    public function export_employee_pdf(Request $request){

        

        $id = $request->id;
        $userID = Auth::id();
        $profile =  User::whereId($request->id)->with(['user_supervisor', 'personalInformation', 'pdsChoices', 'otherInformation', 
        'permanentAddress', 'residentialAddress','spouse', 'children', 'father', 'maidenName', 'elementary', 'secondary', 'vocational', 
        'college', 'graduate', 'civilService', 'workExperience', 'voluntaryWork', 'learningDevelopment', 'skillHobby', 'choice', 'reference', 
        'governmentIssuedId', 'fileAttachment'])->get();

        $response = array();
        $personal_information = array();
        $permanent_address = array();
        $residential_address = array();
        $pds_choices = array();
        $other_information = array();
        $spouse = array();
        $children = array();
        $father = array();
        $maiden_name = array();
        $elementary = array();
        $secondary = array();
        $vocational = array();
        $college = array();
        $graduate = array();
        $civil_service = array();
        $work_experience = array();
        $voluntary_work = array();
        $learning_development = array();
        $skill_hobby = array();
        $choice = array();
        $reference = array();
        $government_issued_id = array();
        $file_attachment = array();

        foreach ($profile as $records => $value)
        {   

            if(!is_null($value->personalInformation))
            {
                foreach($value->personalInformation->EmployeeExtraFieldColumn as $values)
                {
                    $personal_information[$values['field_name']] = $values['field_value'];
                
                }  
            } 
                  
            if(!is_null($value->permanentAddress))
            {
                foreach($value->permanentAddress->EmployeeExtraFieldColumn as $values)
                {      
                    $permanent_address[$values['field_name']] = $values['field_value'];       
                    
                }   
            }

            if(!is_null($value->residentialAddress))
            {
                foreach($value->residentialAddress->EmployeeExtraFieldColumn as $values)
                {   
                    $residential_address[$values['field_name']] = $values['field_value']; 

                }   
            }

            if(!is_null($value->spouse))
            {
                foreach($value->spouse->EmployeeExtraFieldColumn as $values)
                {             
                    $spouse[$values['field_name']] = $values['field_value'];

                }   
            }

            if(!is_null($value->father))
            {
                foreach($value->father->EmployeeExtraFieldColumn as $values)
                {             
                    $father[$values['field_name']] = $values['field_value'];

                }   
            }

            if(!is_null($value->pdsChoices))
            {
                foreach($value->pdsChoices->EmployeeExtraFieldColumn as $values)
                {             
                    $pds_choices[$values['field_name']] = $values['field_value'];

                }   
            }

            if(!is_null($value->otherInformation))
            {
                foreach($value->otherInformation->EmployeeExtraFieldColumn as $values)
                {             
                    $other_information[$values['field_name']] = $values['field_value'];

                }   
            }

            if(!is_null($value->children))
            {
                foreach($value->children as $key)
                {          
                    $child = [];

                        foreach($key->EmployeeExtraFieldColumn as $values)
                    {          
                        $child[$values['field_name']] = $values['field_value'];   
                    }   
                    array_push($children, $child);
                }   
            }

            if(!is_null($value->maidenName))
            {
                foreach($value->maidenName->EmployeeExtraFieldColumn as $values)
                {             
                    $maiden_name[$values['field_name']] = $values['field_value'];   

                }   
            }

            if(!is_null($value->elementary))
            {
                foreach($value->elementary as $key)
                {    
                    $elem = [];

                        foreach($key->EmployeeExtraFieldColumn as $values)
                    {          
                        $elem[$values['field_name']] = $values['field_value'];   
                    }   
                    array_push($elementary, $elem);
                    
                }   
            }

            if(!is_null($value->secondary))
            {
                foreach($value->secondary as $key)
                {             
                    $second = [];
                        foreach($key->EmployeeExtraFieldColumn as $values)
                    {             
                        $second[$values['field_name']] = $values['field_value'];  
                    }   
                    array_push($secondary, $second);
                }   
            }


            if(!is_null($value->vocational))
            {
                foreach($value->vocational as $key)
                {            
                    $vocation = [];
                        foreach($key->EmployeeExtraFieldColumn as $values)
                    {             
                        $vocation[$values['field_name']] = $values['field_value'];  
                    }   
                    array_push($vocational, $vocation);
                }   
            }

            if(!is_null($value->college))
            {
                foreach($value->college as $key)
                {          
                    $coll = [];
                        foreach($key->EmployeeExtraFieldColumn as $values)
                    {             
                        $coll[$values['field_name']] = $values['field_value'];  

                    }   
                    array_push($college, $coll);
                }   
            }

            if(!is_null($value->graduate))
            {
                foreach($value->graduate as $key)
                {             
                    $grad = [];
                        foreach($key->EmployeeExtraFieldColumn as $values)
                    {             
                        $grad[$values['field_name']] = $values['field_value'];

                    }   
                    array_push($graduate, $grad);
                 
                }   
            }

            if(!is_null($value->civilService))
            {
                foreach($value->civilService as $key)
                {             
                    $civil= []; 
                        foreach($key->EmployeeExtraFieldColumn as $values)
                    {     
                        $civil[$values['field_name']] = $values['field_value'];
                    }   
                    array_push($civil_service, $civil);
                }   
            }

            if(!is_null($value->workExperience))
            {
                foreach($value->workExperience as $key)
                {          
                    $workExp= [];    
                        foreach($key->EmployeeExtraFieldColumn as $values)
                    {             
                        $workExp[$values['field_name']] = $values['field_value'];
                    }   
                    array_push($work_experience, $workExp);
                }   
            }

            

            if(!is_null($value->voluntaryWork))
            {
                foreach($value->voluntaryWork as $key)
                {          
                    $volunteer= [];     
                        foreach($key->EmployeeExtraFieldColumn as $values)
                    {             
                        $volunteer[$values['field_name']] = $values['field_value'];
                    }   
                    array_push($voluntary_work, $volunteer);
                }   
            }

            if(!is_null($value->learningDevelopment))
            {
                foreach($value->learningDevelopment as $key)
                {             
                    $learnDev= [];  
                        foreach($key->EmployeeExtraFieldColumn as $values)
                    {             
                        $learnDev[$values['field_name']] = $values['field_value'];
                    }   
                    array_push($learning_development, $learnDev);

                }   
            }

            if(!is_null($value->skillHobby))
            {
                foreach($value->skillHobby as $key)
                {             
                    $skill= []; 
                        foreach($key->EmployeeExtraFieldColumn as $values)
                    {             
                        $skill[$values['field_name']] = $values['field_value'];
                    }   
                    array_push($skill_hobby, $skill);
                }   
            }

            if(!is_null($value->choice))
            {
                foreach($value->choice->EmployeeExtraFieldColumn as $values)
                {             
                    $choice[$values['field_name']] = $values['field_value'];
                }   
            }

            if(!is_null($value->reference))
            {
                foreach($value->reference as $key)
                {             
                    $refer= []; 
                        foreach($key->EmployeeExtraFieldColumn as $values)
                    {             
                        $refer[$values['field_name']] = $values['field_value'];
                    }   
                    array_push($reference, $refer);
                }   
            }

            if(!is_null($value->governmentIssuedId))
            {
                foreach($value->governmentIssuedId as $key)
                {             
                    $refer= []; 
                        foreach($key->EmployeeExtraFieldColumn as $values)
                    {             
                        $government_id[$values['field_name']] = $values['field_value'];
                    }   
                    array_push($government_issued_id, $government_id);
                }   
            }

            if(!is_null($value->fileAttachment))
            {
                foreach($value->fileAttachment->EmployeeExtraFieldColumn as $values)
                {             
                    $file_attachment[$values['field_name']] = $values['field_value'];
                }   
            }
          
            $this->logCustomMessage(
                'download_pds',
                $value,
                Auth::user()->name . ' downloaded the PDS' ,
                $value,
                PDSLogType::UPDATE,
                new Activity()
            );
        }
        
        array_push($response, ['personal_information', 'permanent_address', 'residential_address', 'spouse', 'father', 
        'children' , 'maiden_name', 'elementary', 'secondary', 'vocational', 'college', 'graduate', 'civil_service', 'work_experience',
    'voluntary_work', 'learning_development', 'skill_hobby','pds_choices','other_information', 'choice', 'reference', 'government_issued_id', 'file_attachment']);

    $pds = [
        'personal_information' => $personal_information,
        'permanent_address' => $permanent_address,
        'residential_address' => $residential_address,
        'pds_choices' => $pds_choices,
        'other_information' => $other_information,
        'spouse' => $spouse,
        'children' => $children,
        'father' => $father,
        'maiden_name' => $maiden_name,
        'elementary' => $elementary,
        'secondary' => $secondary,
        'vocational' => $vocational,
        'college' => $college,
        'graduate' => $graduate,
        'civil_service' => $civil_service,
        'work_experience' => $work_experience,
        'voluntary_work' => $voluntary_work,
        'learning_development' => $learning_development,
        'skill_hobby' => $skill_hobby,
        'choice' => $choice,
        'reference' => $reference,
        'government_issued_id' => $government_issued_id,
        'file_attachment' => $file_attachment,
    ];

        return Excel::download(new PDSExports($pds),  'PDS-data.xlsx');

    }

}
