<?php

namespace Suiterus\Adg\Controllers\Mentorship;

use App\Http\Controllers\Controller;
use Suiterus\Adg\Models\Mentorship\MentorshipMentor;
use Suiterus\Adg\Requests\Mentorship\Invite\PaginateRequest;

class MentorshipMentorController extends Controller
{
    public function paginate(PaginateRequest $request)
    {
        $paginate = $request->page_count ? intval($request->page_count) : env('DEFAULT_PAGECOUNT');
        return MentorshipMentor::with(['session', 'session.mentorship', 'session.dates', 'session.mentors.mentor', 'session.invites.mentee', 'session.attachments'])->when($request->user_id != null && isset($request->user_id) && $request->user_id != '', function ($query) use ($request) {
            $query->where('mentor_id', $request->user_id);
        })->paginate($paginate);
    }
}
