<?php

namespace Suiterus\Adg\Controllers\Mentorship;

use Exception;
use Illuminate\Http\Request;
use App\Traits\Logs\HasCustomLogs;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Suiterus\Adg\Models\Activity\Activity;
use Suiterus\Adg\Models\Mentorship\Mentorship;
use Suiterus\Adg\Requests\Mentorship\StoreRequest;
use Suiterus\Adg\Requests\Mentorship\PaginateRequest;

class MentorshipController extends Controller
{

    use HasCustomLogs;

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreRequest $request)
    {
        DB::beginTransaction();
        try {
            $mentorship = $request->all();

            $mentorship = Mentorship::create($mentorship);

            DB::commit();

            $this->logCustomMessage('create_mentorship', $mentorship, Auth::user()->name . ' has created a mentorship named ' . $mentorship->program_title , $mentorship, 'Create a mentorship', new Activity());

            return response()->json([
                'message' => 'Mentorship created successfully',
            ], 200);

        } catch (Exception $e) {
            DB::rollBack();
            return response()->json([
                'message' => 'Something went wrong',
            ], 500);
        }
    }

    public function paginate(PaginateRequest $request)
    {
        $paginate = $request->page_count ? intval($request->page_count) : env('DEFAULT_PAGECOUNT');
        return Mentorship::when($request->invitation_id != null && isset($request->invitation_id) && $request->invitation_id != '', function($query) use($request) {
            $query->where('id', $request->invitation_id);
        })->when($request->created_by != null && isset($request->created_by) && $request->created_by != '', function($query) use($request) {
            $query->whereHas('createdBy', function($query) use($request){
                $query->where('name', 'LIKE', '%'.$request->created_by.'%');
            });
        })->when($request->created_at != null && isset($request->created_at) && $request->created_at != '', function($query) use($request) {
            $query->whereDate('created_at', $request->created_at);
        })->when($request->date != null && isset($request->date) && $request->date != '', function($query) use($request) {
            $query->whereHas('sessions.dates', function($query) use($request){
                $query->whereDate('date', $request->date);
            });
        })->when($request->mentors != null && isset($request->mentors) && $request->mentors != '', function($query) use($request) {
            $query->whereHas('sessions.mentors.mentor', function($query) use($request){
                $query->whereIn('id', $request->mentors);
            });
        })->with(['sessions', 'sessions.dates', 'sessions.mentors.mentor', 'sessions.invites.mentee'])->paginate($paginate);
    }



}
