<?php

namespace Suiterus\Adg\Controllers\Mentorship;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;
use Suiterus\Adg\Models\Mentorship\MentorshipAttachment;
use Suiterus\Adg\Requests\Mentorship\Attachment\DownloadRequest;


class MentorshipAttachmentController extends Controller
{
    public function download(DownloadRequest $request){
        $attachment = MentorshipAttachment::find($request->id);
        return Storage::disk('mentorship_attachment')->download($attachment->file_path);
    }
}
