<?php
namespace Suiterus\Adg\Controllers\Loan\Employee;

use Exception;
use App\Models\UserLoan;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;


class LoanEmployeeController extends Controller
{
    public function fetch_employee_loans(Request $req) {
        $paginate = $req->paginate ? intval($req->paginate) : env('DEFAULT_PAGECOUNT');
        $records = UserLoan::where('user_id', $req->id)->with(['user' => function($q) { 

            $q->select('id','name')->without(['storage','roles','permissions','department','branch','division','position','employeeMetaInfo']); 
            }
        ])->where('status', '!=', 4);

        return response()->json([
            'data'   =>  $records->paginate($paginate)
        ]);
    }

    public function fetch_approved_loans(Request $req) {
        $paginate = $req->paginate ? intval($req->paginate) : env('DEFAULT_PAGECOUNT');
        $records = UserLoan::where('user_id', $req->id)->where('status', 4)->with(['user' => function($q) { 

            $q->select('id','name')->without(['storage','roles','permissions','department','branch','division','position','employeeMetaInfo']); 
            }
        ])
        ->when($req->loanType != '' && $req->loanType != null, function($query) use($req){
            return $query->where('loan_id', $req->loanType);
        })
        ->when($req->filter_dates != '' && $req->filter_dates != null, function($query) use ($req){
            return $query->where('submission_date', $req->filter_dates);
        });

        return response()->json([
            'data'   =>  $records->paginate($paginate)
        ]);
    }
}
