<?php

namespace Suiterus\Adg\Controllers\LeaveManagement\Services;

use App\Enums\Payroll\PayrollStatus;
use Suiterus\Adg\Models\Payroll\LeaveRefund;
use Suiterus\Adg\Models\Payroll\TimekeepingDeduction;

class LeaveRefundService
{
    public function createLeaveRefund($leave)
    {
        $deductions = TimekeepingDeduction::whereHas('employee_payroll', function ($query) use ($leave) {
            $query->where('user_id', $leave->user_id)
                ->whereHas('payroll', function ($query) {
                    $query->where('status', PayrollStatus::DISBURSED);
                });
        })
            ->whereColumn('leave_balance_deduction', '>', 'leave_balance_remaining')
            ->whereDate('date', '>=', $leave->start_date)
            ->whereDate('date', '<=', $leave->end_date)
            ->get();

        if ($deductions->isEmpty()) {
            return;
        }

        $totalAmountToRefund = $deductions->sum('basic_pay_deduction') + $deductions->sum('pera_deduction');
        $totalCreditsToRefund = 0;
        $dates = [];
        foreach ($deductions as $deduction) {
            $totalCreditsToRefund += $deduction->leave_balance_deduction;
            $dates[] = $deduction->date;
        }
        $dates = implode(", ", $dates);
        $reason = "Request to refund the deducted leave credits and lwop for the dates of " . $dates . ".";
        $leaveRefund = LeaveRefund::Create([
            'user_id' => $leave->user_id,
            'leave_id' => $leave->id,
            'total_credits' => $totalCreditsToRefund,
            'total_amount' => $totalAmountToRefund,
            'reason' => $reason,
            'status' => 3 // for review
        ]);

        foreach ($deductions as $deduction) {
            $leaveRefund->leaveRefundDetails()->create([
                'date' => $deduction->date,
                'credits' => $deduction->leave_balance_remaining > 0 ? $deduction->leave_balance_deduction : 0,
                'amount' => $deduction->basic_pay_deduction + $deduction->pera_deduction
            ]);
        }
    }

    public function updateLeaveRefund($status, $leave) {
        $leaveRefund = LeaveRefund::where('user_id', $leave->user_id)
            ->where('leave_id', $leave->id)
            ->first();

        if ($leaveRefund) {
            $leaveRefund->status  = $status;
            $leaveRefund->save();
        }
    }
}