<?php

namespace Suiterus\Adg\Controllers\LeaveManagement;

use App\Models\User;
use App\Http\Controllers\Controller;
use Suiterus\Adg\Services\LeaveManagement\LeaveEligibleService;
use Suiterus\Adg\Requests\Users\ValidateUserIdRequest;

class LeaveEligibleController extends Controller
{

    public function showEligibleLeaveType(ValidateUserIdRequest $request)
    {
        $user = User::without([
            'permissions',
            'storage',
            'employeeMetaInfo',
            'supervisor',
            'exitInterview',
            'userProfilePicture',
            'profileBasicInfo'
        ])->find($request->id);

        return (new LeaveEligibleService)->getUserEligibleLeaveTypes($user);
    }
}
