<?php

namespace Suiterus\Adg\Controllers\LeaveManagement;

use App\Enums\LeaveType as EnumsLeaveType;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use Exception;
use Illuminate\Support\Facades\Validator;
use Suiterus\Adg\Models\LeaveManagement\Crediting\LeaveBalance;
use Suiterus\Adg\Models\LeaveManagement\Crediting\LeaveCreditDeduction;
use Suiterus\Adg\Models\LeaveManagement\Crediting\LeaveCreditEarning;
use Suiterus\Adg\Models\LeaveManagement\LeaveCreditHistory;
use Suiterus\Adg\Models\LeaveManagement\Requests\Leave;
use Suiterus\Adg\Requests\Users\ValidateUserIdRequest;

class LeaveCreditController extends Controller
{

    public function paginateByUserLeaveId(Request $request)
    {
        $paginate = $request->paginate ? intval($request->paginate) : env('DEFAULT_PAGECOUNT');

        return LeaveCreditHistory::where([
            ['user_id', $request->user_id],
            ['leave_type_id', $request->leave_type_id],
        ])->whereYear('period', $request->year)->paginate($paginate);
    }

    // Fetch Leave Earnings and Deductions
    public function fetch_credits(Request $request)
    {

        $paginate = $request->paginate ? intval($request->paginate) : env('DEFAULT_PAGECOUNT');

        try {

            return $request;

        } catch (Exception $e) {
            return response()->json([
                'errors'    => ['There was a problem in fetching the records'],
                'message'   => $e->getMessage(),
            ], 500);
        }
    }

    public function fetch_leave_users(Request $request)
    {

        $paginate = $request->paginate ? intval($request->paginate) : env('DEFAULT_PAGECOUNT');

        try {

            $users = User::whereHas('employeeMetaInfo', function ($query) use ($request) {
                $query->when(isset($request->position) && $request->position != null, function ($query) use ($request) {
                    $query->whereHas('position', function ($query) use ($request) {
                        $query->whereId($request->position);
                    });
                })
                    ->when(isset($request->department) && $request->department != null, function ($query) use ($request) {
                        $query->whereHas('department', function ($query) use ($request) {
                            $query->whereId($request->department);
                        });
                    });
            })
                ->when(isset($request->employees) && count($request->employees) > 0, function ($query) use ($request) {
                    $query->whereIn('id', $request->employees);
                })
                ->when(isset($request->supervisor) && $request->supervisor != null, function ($query) use ($request) {
                    $query->whereHas('user_supervisor.supervisor.user', function ($query) use ($request) {
                        $query->whereId($request->supervisor);
                    });
                })
                ->where('name', 'LIKE', '%' . $request->employee_name . '%')
                ->with([
                    'user_supervisor' => function ($query) {
                        $query->with([
                            'supervisor' => function ($query) {
                                $query->with(['user' => function ($query) {
                                    $query->without(['roles', 'permissions', 'supervisor', 'storage', 'employeeMetaInfo']);
                                }]);
                            },
                        ]);
                    },
                ])->has('leave_balance')
                ->without(['storage', 'permissions', 'roles', 'supervisor'])
                ->paginate($paginate);

            return response()->json([
                'data'  => $users
            ]);
        } catch (Exception $e) {
            return response()->json([
                'errors'    => ['There was a problem in fetching the users'],
                'message'   => $e->getMessage()
            ]);
        }
    }

    public function fetch_balances(ValidateUserIdRequest $request)
    {
        return LeaveBalance::where([
            ['user_id', $request->id],
            ['balance', '!=', null]
        ])->with(['leave_type'])->get();
    }

    public function fetch_balance_by_leave_type(Request $request){
        return LeaveBalance::where([
            ['user_id', $request->user_id],
            ['leave_type_id', $request->leave_type_id]
        ])->with(['leave_type'])->first();
    }
}
