<?php

namespace Suiterus\Adg\Controllers\LeaveManagement;

use Exception;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Traits\Logs\HasCustomLogs;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Enums\Log\LeaveManagementLogType;
use Suiterus\Adg\Models\Activity\Activity;
use Suiterus\Adg\Requests\LeaveBalance\UpdateRequest;
use Suiterus\Adg\Models\LeaveManagement\LeaveCreditHistory;
use Suiterus\Adg\Models\LeaveManagement\Crediting\LeaveBalance;
use Suiterus\Adg\Requests\LeaveEligible\ShowEligibleLeaveRequest;

class LeaveBalanceController extends Controller
{
    use HasCustomLogs;

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(ShowEligibleLeaveRequest $request, $id)
    {
        return LeaveBalance::where([
            'leave_type_id' => $id,
            'user_id' => $request->user_id
        ])->first();
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateRequest $request)
    {
        DB::connection(env('ADG_DB_CONNECTION'))->beginTransaction();

        try {

            $oldRecord = LeaveBalance::where([
                ['user_id', $request->user_id],
                ['leave_type_id', $request->leave_type_id]
            ])->with('leave_type', 'user')->first();

            LeaveBalance::where([
                ['user_id', $request->user_id],
                ['leave_type_id', $request->leave_type_id]
            ])->update([
                'balance' => $request->new_balance,
                'updated_by' => Auth::id()
            ]);

            $deducted = 2;
            $added = 1;

            $leaveAdjustmentType = (bool) $request->is_negative ? $deducted : $added;

            LeaveCreditHistory::create([
                'user_id' => $request->user_id,
                'leave_type_id' => $request->leave_type_id,
                'credits' => $request->credits,
                'resulting_balance' => $request->new_balance,
                'leave_adjustment_type' => $leaveAdjustmentType,
                'remarks' => $request->remarks,
                'period' => Carbon::now(),
                'created_by' => Auth::id(),
            ]);

            $newRecord = LeaveBalance::where([
                ['user_id', $request->user_id],
                ['leave_type_id', $request->leave_type_id]
            ])->with('leave_type', 'user')->first();

            $newRecord->old = collect($oldRecord);
            $newRecord->attributes = collect($newRecord);

            $this->logCustomMessage(
                'update_leave_balance',
                $newRecord,
                Auth::user()->name . ' updated the ' . $newRecord->leave_type->title . ' of ' . $newRecord->user->name,
                $newRecord,
                LeaveManagementLogType::UPDATE_BALANCE,
                new Activity()
            );
            
            DB::connection(env('ADG_DB_CONNECTION'))->commit();

            return response()->json([
                'message' => 'Success'
            ], 200);
        } catch (Exception $e) {
            DB::connection(env('ADG_DB_CONNECTION'))->rollBack();
            return response()->json([
                'error' => "We're sorry, but something went wrong on our end. Please try again later."
            ], 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
